/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.AbstractTextBuffer;

final class VectorBuffers {
    private char[][] _buffers = new char[20][];
    private int[] _bufferSizes = new int[20];
    private int _bufferCount = 0;

    public int getBufferCount() {
        return this._bufferCount;
    }

    public char[] getBuffer(int index) {
        return this._buffers[index];
    }

    public int getBufferLength(int index) {
        return this._bufferSizes[index];
    }

    public void addBuffer(char[] buffer, int length) {
        if (this._bufferCount == this._buffers.length) {
            char[][] newBuffers = new char[this._bufferCount + 20][];
            int[] newSizes = new int[this._bufferCount + 20];
            System.arraycopy(this._buffers, 0, newBuffers, 0, this._bufferCount);
            System.arraycopy(this._bufferSizes, 0, newSizes, 0, this._bufferCount);
            this._buffers = newBuffers;
            this._bufferSizes = newSizes;
        }
        this._buffers[this._bufferCount] = buffer;
        this._bufferSizes[this._bufferCount] = length;
        ++this._bufferCount;
    }

    public int getTotalLength() {
        int total = 0;
        int i = 0;
        while (i < this._bufferCount) {
            total += this._bufferSizes[i];
            ++i;
        }
        return total;
    }

    private void consolidateBuffers() {
        int total = this.getTotalLength();
        char[] buffer = new char[total];
        int writePos = 0;
        int i = 0;
        while (i < this._bufferCount) {
            int charsToCopy = this._bufferSizes[i];
            System.arraycopy(this._buffers[i], 0, buffer, writePos, charsToCopy);
            writePos += charsToCopy;
            ++i;
        }
        this._buffers = new char[][]{buffer};
        this._bufferSizes = new int[]{total};
        this._bufferCount = 1;
    }

    public char[] getAllBuffers() {
        if (this._bufferCount == 0) {
            return AbstractTextBuffer.EMPTY_CHARS;
        }
        this.consolidateBuffers();
        return this.getBuffer(0);
    }
}

