/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import javax.swing.text.Segment;
import oracle.javatools.buffer.ReadTextBuffer;

final class StringReadTextBuffer
implements ReadTextBuffer {
    private String dataSource;

    StringReadTextBuffer(String dataSource) {
        this.dataSource = dataSource;
    }

    public int getLength() {
        return this.dataSource.length();
    }

    public char getChar(int offset) throws IndexOutOfBoundsException {
        return this.dataSource.charAt(offset);
    }

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length");
        }
        char[] buffer = new char[length];
        if (length > 0) {
            this.dataSource.getChars(offset, offset + length, buffer, 0);
        }
        return buffer;
    }

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length");
        }
        return this.dataSource.substring(offset, offset + length);
    }

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        segment.array = this.getChars(offset, length);
        segment.offset = 0;
        segment.count = length;
    }

    public void readLock() {
    }

    public boolean tryReadLock() {
        return true;
    }

    public void readUnlock() {
    }

    public int getLockStatus() {
        return -1;
    }
}

