/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SafeArrayList
extends AbstractList
implements RandomAccess,
Cloneable {
    private Object[] _data;
    private Object _lock;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    private void $init$() {
        this._lock = new Object();
    }

    public SafeArrayList() {
        this.$init$();
        this._data = EMPTY_ARRAY;
    }

    public SafeArrayList(Collection c) {
        this.$init$();
        this._data = c.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this._lock;
        synchronized (object) {
            int n = this._data.length;
            return n;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object element) {
        Object[] data;
        Object object = this._lock;
        synchronized (object) {
            data = this._data;
        }
        int size = data.length;
        if (element == null) {
            int i = 0;
            while (i < size) {
                if (data[i] == null) {
                    return i;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < size) {
                if (element.equals(data[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object element) {
        Object[] data;
        Object object = this._lock;
        synchronized (object) {
            data = this._data;
        }
        int size = data.length;
        if (element == null) {
            int i = size - 1;
            while (i >= 0) {
                if (data[i] == null) {
                    return i;
                }
                --i;
            }
        } else {
            int i = size - 1;
            while (i >= 0) {
                if (element.equals(data[i])) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this._lock;
        synchronized (object) {
            SafeArrayList copy = new SafeArrayList();
            copy._data = this._data;
            SafeArrayList safeArrayList = copy;
            return safeArrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object[] data;
        Object object = this._lock;
        synchronized (object) {
            data = this._data;
        }
        int size = data.length;
        Object[] result = new Object[size];
        System.arraycopy(data, 0, result, 0, size);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] array) {
        Object[] data;
        Object object = this._lock;
        synchronized (object) {
            data = this._data;
        }
        int size = data.length;
        if (array.length < size) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        }
        System.arraycopy(data, 0, array, 0, size);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(int index) {
        Object object = this._lock;
        synchronized (object) {
            Object object2 = this._data[index];
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object set(int index, Object element) {
        Object object = this._lock;
        synchronized (object) {
            Object old = this._data[index];
            this._data[index] = element;
            Object object2 = old;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object element) {
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object[] newData = new Object[size + 1];
            System.arraycopy(this._data, 0, newData, 0, size);
            newData[size] = element;
            this._data = newData;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object element) {
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object[] newData = new Object[size + 1];
            System.arraycopy(this._data, 0, newData, 0, index);
            System.arraycopy(this._data, index, newData, index + 1, size - index);
            newData[index] = element;
            this._data = newData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        Object object = this._lock;
        synchronized (object) {
            int index = this.indexOf(element);
            if (index != -1) {
                this.remove(index);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object remove(int index) {
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object old = this._data[index];
            Object[] newData = new Object[size - 1];
            System.arraycopy(this._data, 0, newData, 0, index);
            System.arraycopy(this._data, index + 1, newData, index, size - index - 1);
            this._data = newData;
            Object object2 = old;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._data = EMPTY_ARRAY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection c) {
        Object[] objectsToAdd = c.toArray();
        int countToAdd = objectsToAdd.length;
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object[] newData = new Object[size + countToAdd];
            System.arraycopy(this._data, 0, newData, 0, size);
            System.arraycopy(objectsToAdd, 0, newData, size, countToAdd);
            this._data = newData;
        }
        return countToAdd > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection c) {
        Object[] objectsToAdd = c.toArray();
        int countToAdd = objectsToAdd.length;
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object[] newData = new Object[size + countToAdd];
            System.arraycopy(this._data, 0, newData, 0, index);
            System.arraycopy(objectsToAdd, 0, newData, index, countToAdd);
            System.arraycopy(this._data, index, newData, index + countToAdd, size - index);
            this._data = newData;
        }
        return countToAdd > 0;
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeRange(int startIndex, int endIndex) {
        int countToRemove = endIndex - startIndex;
        Object object = this._lock;
        synchronized (object) {
            int size = this._data.length;
            Object[] newData = new Object[size - countToRemove];
            System.arraycopy(this._data, 0, newData, 0, startIndex);
            System.arraycopy(this._data, endIndex, newData, startIndex, size - endIndex);
            this._data = newData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator iterator() {
        Object object = this._lock;
        synchronized (object) {
            SafeListIterator safeListIterator = new SafeListIterator(0, this._data);
            return safeListIterator;
        }
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListIterator listIterator(int index) {
        Object object = this._lock;
        synchronized (object) {
            SafeListIterator safeListIterator = new SafeListIterator(index, this._data);
            return safeListIterator;
        }
    }

    @Override
    public List subList(int startIndex, int endIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Iterator iterator;
        int size;
        Object object = this._lock;
        synchronized (object) {
            size = this._data.length;
            iterator = this.iterator();
        }
        StringBuffer buffer = new StringBuffer("SafeArrayList: ");
        buffer.append(size);
        buffer.append(" objects");
        while (iterator.hasNext()) {
            buffer.append("\n  ");
            buffer.append(iterator.next().toString());
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SafeListIterator
    implements ListIterator {
        private Object[] _snapshotData;
        private int _index;
        private int _start;

        protected SafeListIterator(int start, Object[] data) {
            this._snapshotData = data;
            this._index = this._start = start;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._snapshotData.length;
        }

        @Override
        public Object next() {
            try {
                if (this._index < this._snapshotData.length) {
                    Object object = this._snapshotData[this._index++];
                    return object;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this._index > this._start;
        }

        public Object previous() {
            try {
                if (this._index > this._start) {
                    Object object = this._snapshotData[--this._index];
                    return object;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this._index;
        }

        @Override
        public int previousIndex() {
            if (this._index > this._start) {
                return this._index - 1;
            }
            return -1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

