/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;

final class ArrayLineMap
implements LineMap {
    private static final int INITIAL_MAP_SIZE = 16;
    private ReadTextBuffer textBuffer;
    private int[] map;
    private int lines;
    private static final int MINIMUM_INCREMENT = 25;
    private static final int MAXIMUM_INCREMENT = 500;
    private static final float INCREMENT_RATE = 0.1f;

    ArrayLineMap(ReadTextBuffer buffer) {
        this.textBuffer = buffer;
        this.map = new int[16];
        this.lines = 1;
        this.map[0] = 0;
        this.map[1] = 0;
        int initialLength = buffer.getLength();
        if (initialLength > 0) {
            char[] bufferData = buffer.getChars(0, initialLength);
            this.insertUpdate(0, initialLength, bufferData);
        }
    }

    public TextBuffer getTextBuffer() {
        if (this.textBuffer instanceof TextBuffer) {
            return (TextBuffer)this.textBuffer;
        }
        return null;
    }

    void insertUpdate(int offset, int count, char[] insertedData) {
        int new_lines = 0;
        int i = 0;
        while (i < count) {
            if (insertedData[i] == '\n') {
                ++new_lines;
            }
            ++i;
        }
        int insertPoint = this.getLineFromOffset(offset);
        int shiftLine = insertPoint + 1;
        int[] newMap = this.map;
        int newMapSize = this.lines + 1 + new_lines;
        int oldMapSize = this.map.length;
        if (newMapSize > oldMapSize) {
            int increment = (int)((float)newMapSize * 0.1f);
            increment = Math.min(500, increment);
            increment = Math.max(25, increment);
            newMap = new int[newMapSize += increment];
            System.arraycopy(this.map, 0, newMap, 0, shiftLine);
        }
        int i2 = this.lines;
        while (i2 >= shiftLine) {
            newMap[i2 + new_lines] = this.map[i2] + count;
            --i2;
        }
        if (new_lines > 0) {
            int added_line = 0;
            int i3 = 0;
            while (i3 < count) {
                if (insertedData[i3] == '\n') {
                    newMap[added_line + shiftLine] = i3 + offset + 1;
                    ++added_line;
                }
                ++i3;
            }
        }
        this.map = newMap;
        this.lines += new_lines;
    }

    void removeUpdate(int offset, int count, char[] removedData) {
        int shiftLine;
        int startLine = this.getLineFromOffset(offset);
        int endLine = this.getLineFromOffset(offset + count);
        int removed_lines = endLine - startLine;
        int i = shiftLine = endLine + 1;
        while (i <= this.lines) {
            this.map[i - removed_lines] = this.map[i] - count;
            ++i;
        }
        this.lines -= removed_lines;
    }

    public int getLineCount() {
        return this.lines;
    }

    public int getLineFromOffset(int offset) {
        int top_line = 0;
        int bottom_line = this.lines;
        int line_spread;
        while ((line_spread = bottom_line - top_line) != 1) {
            int middle_line = bottom_line + top_line >> 1;
            int middle_offset = this.map[middle_line];
            if (middle_offset > offset) {
                bottom_line = middle_line;
                continue;
            }
            top_line = middle_line;
        }
        return top_line;
    }

    public int getLineStartOffset(int line) {
        return this.map[line];
    }

    public int getLineEndOffset(int line) {
        return this.map[line + 1];
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Lines (" + this.lines + "): ");
        int i = 0;
        while (i <= this.lines) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.map[i]);
            ++i;
        }
        return s.toString();
    }
}

