/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ArrayLineMap;
import oracle.javatools.buffer.DigestHash;
import oracle.javatools.buffer.EOLNormalizer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.LinkedOffsetMark;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.UndoableTextEdit;
import oracle.javatools.util.UnexpectedExceptionError;

public abstract class AbstractTextBuffer
implements TextBuffer {
    protected static final char EOF_MARKER = '\uffff';
    protected static final char[] EMPTY_CHARS = new char[0];
    protected static String platformEOLType = "\r\n";
    private static final UndoableTextEdit START_EDIT = new UndoableTextEdit(null);
    private String bufferEOLType;
    private final CopyOnWriteArrayList<TextBufferListener> listenerList;
    private final LinkedOffsetMark marksListHead;
    protected final ReadWriteLock bufferLock;
    private boolean inChangeNotify;
    private ArrayLineMap lineMap;
    private UndoableTextEdit compoundEdit;
    private Throwable compoundEditStartTrace;
    private int nonModifiedChangeId;
    private int changeId;
    private boolean readOnlyMode;
    private boolean suppressUndo;
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private static int globalNextId = 1001;
    private UndoState undoState;

    protected AbstractTextBuffer(ReadWriteLock lockToUse) {
        this.bufferLock = lockToUse;
        this.listenerList = new CopyOnWriteArrayList();
        this.marksListHead = new LinkedOffsetMark(-1, true);
        this.marksListHead.initializeHead();
        this.bufferEOLType = platformEOLType;
        this.inChangeNotify = false;
        this.lineMap = null;
        this.compoundEdit = null;
        this.readOnlyMode = false;
        this.nextChangeId();
        this.setSuppressUndo(false);
        this.clearModified();
        this.undoState = new UndoState(this);
    }

    public void setReadOnly(boolean readOnly) {
        this.readLock();
        try {
            this.readOnlyMode = readOnly;
            this.fireAttributeUpdate(2);
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public abstract int getLength();

    public abstract char getChar(int var1) throws IndexOutOfBoundsException;

    public char[] getChars(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            if (length == 0) {
                return EMPTY_CHARS;
            }
            throw new IndexOutOfBoundsException("length " + length + " < 0");
        }
        return this.getCharsImpl(offset, length);
    }

    protected abstract char[] getCharsImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public String getString(int offset, int length) throws IndexOutOfBoundsException {
        if (length < 0) {
            if (length == 0) {
                return "";
            }
            throw new IndexOutOfBoundsException("length " + length + " < 0");
        }
        return this.getStringImpl(offset, length);
    }

    protected abstract String getStringImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public void getText(int offset, int length, Segment segment) throws IndexOutOfBoundsException {
        if (length == 0) {
            segment.array = EMPTY_CHARS;
            segment.offset = 0;
            segment.count = 0;
        } else {
            this.getTextImpl(offset, length, segment);
        }
    }

    protected abstract void getTextImpl(int var1, int var2, Segment var3) throws IndexOutOfBoundsException;

    public UndoableEdit insert(int offset, char[] data) throws ReadOnlyException {
        try {
            EOLNormalizer normalizer = EOLNormalizer.getNormalizer(data);
            char[] normalizedData = normalizer.normalizeData();
            UndoableEdit undoableEdit = this.normalizedInsert(offset, normalizedData);
            return undoableEdit;
        }
        catch (IOException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    protected UndoableEdit normalizedInsert(int offset, char[] data) throws ReadOnlyException {
        UndoableTextEdit edit = null;
        if (data == null || data.length == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean generateUndo = this.isSuppressUndo() ^ true;
        this.writeLock();
        try {
            if (generateUndo) {
                edit = new UndoableTextEdit(this.undoState);
                edit.recordStart();
            }
            this.insertImpl(offset, data);
            boolean modifiedChanged = this.nextChangeId();
            if (generateUndo) {
                edit.recordEdit(offset, data.length, data, true);
                edit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = edit;
                    } else {
                        this.compoundEdit.addEdit(edit);
                    }
                    edit = null;
                }
            }
            this.fireInsertUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected void applyInsert(int offset, char[] data, int oldChangeId) throws ReadOnlyException {
        if (data == null || data.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed", this.compoundEditStartTrace);
        }
        this.writeLock();
        try {
            this.insertImpl(offset, data);
            boolean modifiedChanged = this.setChangeId(oldChangeId);
            this.fireInsertUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit append(char[] data) throws ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            int offset = this.getLength();
            edit = this.insert(offset, data);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected void insertImpl(int offset, char[] data) {
        this.insertImpl(offset, data, 0, data.length);
    }

    protected abstract void insertImpl(int var1, char[] var2, int var3, int var4);

    private void fireInsertUpdate(int offset, char[] data, boolean fireModified) {
        this.inChangeNotify = true;
        try {
            int dataLength = data.length;
            if (this.lineMap != null) {
                this.lineMap.insertUpdate(offset, dataLength, data);
            }
            int markInsertOffset = offset == 0 ? 1 : offset;
            LinkedOffsetMark currentMark = this.marksListHead.nextMark();
            while (currentMark != this.marksListHead) {
                currentMark.insertUpdate(markInsertOffset, dataLength);
                currentMark = currentMark.nextMark();
            }
            if (fireModified) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener listener : this.listenerList) {
                try {
                    listener.insertUpdate(this, offset, dataLength, data);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " inserting " + data.length + " at " + offset, e);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    public UndoableEdit remove(int offset, int count) throws ReadOnlyException {
        UndoableTextEdit edit = null;
        if (count == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean generateUndo = this.isSuppressUndo() ^ true;
        this.writeLock();
        try {
            if (generateUndo) {
                edit = new UndoableTextEdit(this.undoState);
                edit.recordStart();
            }
            char[] data = this.getChars(offset, count);
            this.removeImpl(offset, count);
            boolean modifiedChanged = this.nextChangeId();
            if (generateUndo) {
                edit.recordEdit(offset, count, data, false);
                edit.recordEnd();
                if (this.compoundEdit != null) {
                    if (this.compoundEdit == START_EDIT) {
                        this.compoundEdit = edit;
                    } else {
                        this.compoundEdit.addEdit(edit);
                    }
                    edit = null;
                }
            }
            this.fireRemoveUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected void applyRemove(int offset, char[] data, int oldChangeId) throws ReadOnlyException {
        if (data == null || data.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed");
        }
        this.writeLock();
        try {
            int count = data.length;
            this.removeImpl(offset, count);
            boolean modifiedChanged = this.setChangeId(oldChangeId);
            this.fireRemoveUpdate(offset, data, modifiedChanged);
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit removeToEnd(int offset) throws ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            int count = this.getLength() - offset;
            edit = this.remove(offset, count);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    protected abstract void removeImpl(int var1, int var2);

    private void fireRemoveUpdate(int offset, char[] data, boolean fireModified) {
        this.inChangeNotify = true;
        try {
            int dataLength = data.length;
            if (this.lineMap != null) {
                this.lineMap.removeUpdate(offset, dataLength, data);
            }
            LinkedOffsetMark currentMark = this.marksListHead.nextMark();
            while (currentMark != this.marksListHead) {
                currentMark.removeUpdate(offset, dataLength);
                currentMark = currentMark.nextMark();
            }
            if (fireModified) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener listener : this.listenerList) {
                try {
                    listener.removeUpdate(this, offset, dataLength, data);
                }
                catch (Throwable e) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " removing " + data.length + " from " + offset, e);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    public LineMap getLineMap() {
        if (this.lineMap == null) {
            this.readLock();
            try {
                this.lineMap = new ArrayLineMap(this);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.lineMap;
    }

    public void addTextBufferListener(TextBufferListener listener) {
        this.listenerList.addIfAbsent(listener);
    }

    public void removeTextBufferListener(TextBufferListener listener) {
        this.listenerList.remove(listener);
    }

    public void readLock() {
        this.bufferLock.readLock();
    }

    public boolean tryReadLock() {
        return this.bufferLock.tryReadLock();
    }

    public void readUnlock() {
        this.bufferLock.readUnlock();
    }

    public int getLockStatus() {
        if (this.bufferLock.isWriteLockHeld()) {
            return 2;
        }
        if (this.bufferLock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    public void writeLock() throws ReadOnlyException {
        this.writeLock(true);
    }

    public void writeLock(boolean checkIfReadOnly) throws ReadOnlyException {
        if (checkIfReadOnly && this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLock();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.bufferLock.tryWriteLock();
    }

    public void writeUnlock() {
        this.bufferLock.writeUnlock();
    }

    public void beginEdit() throws ReadOnlyException {
        this.writeLock();
        if (this.compoundEdit != null) {
            this.writeUnlock();
            throw new IllegalStateException("Already in compound edit");
        }
        this.compoundEditStartTrace = new Throwable("beginEdit diagnostic trace");
        this.compoundEdit = START_EDIT;
    }

    public UndoableEdit endEdit() {
        if (this.compoundEdit == null) {
            throw new IllegalStateException("Not in compound edit");
        }
        UndoableTextEdit edit = null;
        if (this.compoundEdit != START_EDIT) {
            edit = this.compoundEdit;
        }
        this.compoundEdit = null;
        this.compoundEditStartTrace = null;
        this.writeUnlock();
        return edit;
    }

    public boolean isModified() {
        boolean isModified = this.nonModifiedChangeId != this.getChangeId();
        return isModified;
    }

    public void clearModified() {
        this.clearModified(true);
    }

    private void clearModified(boolean sendEvent) {
        int changeId = this.getChangeId();
        boolean wasModified = changeId != this.nonModifiedChangeId;
        this.nonModifiedChangeId = changeId;
        if (wasModified && sendEvent) {
            this.writeLock();
            try {
                this.fireAttributeUpdate(5);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public int getChangeId() {
        return this.changeId;
    }

    private boolean setChangeId(int changeId) {
        boolean wasModified = this.isModified();
        this.changeId = changeId;
        return wasModified != this.isModified();
    }

    private static synchronized int requestNextChangeId() {
        return globalNextId++;
    }

    private boolean nextChangeId() {
        int nextId = AbstractTextBuffer.requestNextChangeId();
        return this.setChangeId(nextId);
    }

    private void setSuppressUndo(boolean suppressUndo) {
        this.suppressUndo = suppressUndo;
    }

    private boolean isSuppressUndo() {
        return this.suppressUndo;
    }

    public void read(Reader reader) throws IOException {
        EOLNormalizer normalizer = EOLNormalizer.getNormalizer(reader);
        this.read(normalizer);
    }

    public void read(FileChannel channel, CharsetDecoder decoder) throws IOException {
        EOLNormalizer normalizer = EOLNormalizer.getNormalizer(channel, decoder);
        this.read(normalizer);
    }

    protected void read(EOLNormalizer normalizer) throws IOException {
        this.setReadOnly(false);
        this.writeLock();
        try {
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no read() during compound edit");
            }
            this.fireAttributeUpdate(3);
            try {
                this.setSuppressUndo(true);
                this.removeToEnd(0);
                char[] data = normalizer.normalizeData();
                this.normalizedInsert(0, data);
                String normalizedEOLType = normalizer.getEOLType();
                if (!platformEOLType.equals(normalizedEOLType)) {
                    this.setEOLType(normalizedEOLType);
                }
                this.clearModified();
                this.setSuppressUndo(false);
            }
            finally {
                this.fireAttributeUpdate(4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    public UndoableEdit insert(int offset, Reader reader) throws IOException, ReadOnlyException {
        UndoableEdit edit = null;
        this.writeLock();
        try {
            EOLNormalizer normalizer = EOLNormalizer.getNormalizer(reader);
            char[] data = normalizer.normalizeData();
            edit = this.normalizedInsert(offset, data);
        }
        finally {
            this.writeUnlock();
        }
        return edit;
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    public void write(Writer writer, boolean clearModified) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.readLock();
        try {
            int length;
            int lineEnd;
            int lineStart;
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no write() during compound edit", this.compoundEditStartTrace);
            }
            Segment segment = new Segment();
            LineMap lineMap = this.getLineMap();
            int lineCount = lineMap.getLineCount() - 1;
            int i = 0;
            while (i < lineCount) {
                lineStart = lineMap.getLineStartOffset(i);
                lineEnd = lineMap.getLineEndOffset(i) - 1;
                length = lineEnd - lineStart;
                if (length > 0) {
                    this.getText(lineStart, length, segment);
                    writer.write(segment.array, segment.offset, segment.count);
                }
                writer.write(this.bufferEOLType);
                ++i;
            }
            lineStart = lineMap.getLineStartOffset(lineCount);
            lineEnd = lineMap.getLineEndOffset(lineCount);
            length = lineEnd - lineStart;
            if (length > 0) {
                this.getText(lineStart, length, segment);
                writer.write(segment.array, segment.offset, segment.count);
            }
            writer.close();
        }
        finally {
            this.readUnlock();
        }
        boolean wasModified = this.isModified();
        int wasModifiedId = this.getChangeId();
        if (clearModified && wasModified) {
            this.bufferLock.writeLockFromReadLock();
            try {
                if (wasModifiedId == this.getChangeId()) {
                    this.clearModified(true);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public String getPlatformEOLType() {
        return platformEOLType;
    }

    public String getEOLType() {
        return this.bufferEOLType;
    }

    public void setEOLType(String eolType) throws ReadOnlyException {
        this.writeLock();
        try {
            this.bufferEOLType = eolType;
            this.fireAttributeUpdate(1);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void fireAttributeUpdate(int attribute) {
        for (TextBufferListener listener : this.listenerList) {
            try {
                listener.attributeUpdate(this, attribute);
            }
            catch (Throwable e) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + listener + " updating attribute  " + attribute, e);
            }
        }
    }

    public OffsetMark addOffsetMark(int offset) {
        return this.addOffsetMark(offset, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetMark addOffsetMark(int offset, boolean bias) {
        LinkedOffsetMark newMark = null;
        this.readLock();
        try {
            newMark = new LinkedOffsetMark(offset, bias);
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                newMark.attachBefore(this.marksListHead);
            }
        }
        finally {
            this.readUnlock();
        }
        return newMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffsetMark(OffsetMark offsetMark) {
        this.readLock();
        try {
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                LinkedOffsetMark linkedMark = (LinkedOffsetMark)offsetMark;
                linkedMark.detach();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    static {
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator != null && lineSeparator.length() == 1) {
            char c = lineSeparator.charAt(0);
            platformEOLType = c == '\r' ? "\r" : "\n";
        }
    }

    protected UndoState detachUndoState() {
        this.writeLock(false);
        try {
            boolean success = UndoState.mav$detachAndSaveState(this.undoState);
            UndoState savedState = success ? this.undoState : null;
            this.undoState = new UndoState(this);
            UndoState undoState = savedState;
            return undoState;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected UndoState copyUndoState() {
        UndoState state = new UndoState(this);
        UndoState.mav$detachAndSaveState(state);
        return state;
    }

    protected boolean attachUndoState(UndoState state) {
        if (state == null) {
            return false;
        }
        this.writeLock(false);
        try {
            boolean success = UndoState.mav$attachAndRestoreState(state, this);
            if (success) {
                UndoState.mav$detachAndDiscard(this.undoState);
                this.undoState = state;
            }
            boolean bl = success;
            return bl;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.writeUnlock();
        }
    }

    static boolean mav$setChangeId(AbstractTextBuffer abstractTextBuffer, int n) {
        return abstractTextBuffer.setChangeId(n);
    }

    static void mav$clearModified(AbstractTextBuffer abstractTextBuffer, boolean bl) {
        abstractTextBuffer.clearModified(bl);
    }

    public static final class UndoState {
        private AbstractTextBuffer _textBuffer;
        private int _changeId;
        private DigestHash _digestHash;

        UndoState(AbstractTextBuffer textBuffer) {
            this._textBuffer = textBuffer;
            this._digestHash = null;
            this._changeId = -1;
        }

        AbstractTextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        private void detachAndDiscard() {
            this._textBuffer = null;
            this._digestHash = null;
        }

        private boolean detachAndSaveState() {
            if (this._textBuffer == null) {
                throw new IllegalStateException("state already detached");
            }
            this._changeId = this._textBuffer.getChangeId();
            this._digestHash = DigestHash.computeDigestHash(this._textBuffer);
            this._textBuffer = null;
            return this._digestHash != null;
        }

        private boolean attachAndRestoreState(AbstractTextBuffer textBuffer) {
            if (this._textBuffer != null) {
                throw new IllegalStateException("state already attached");
            }
            if (this._digestHash == null) {
                return false;
            }
            DigestHash currentHash = DigestHash.computeDigestHash(textBuffer);
            if (!currentHash.equals(this._digestHash)) {
                return false;
            }
            this._textBuffer = textBuffer;
            AbstractTextBuffer.mav$setChangeId(textBuffer, this._changeId);
            AbstractTextBuffer.mav$clearModified(textBuffer, false);
            this._digestHash = null;
            return true;
        }

        public String toString() {
            return "UndoState (buffer " + this._textBuffer + ", id " + this._changeId + ")";
        }

        static boolean mav$attachAndRestoreState(UndoState undoState, AbstractTextBuffer abstractTextBuffer) {
            return undoState.attachAndRestoreState(abstractTextBuffer);
        }

        static void mav$detachAndDiscard(UndoState undoState) {
            undoState.detachAndDiscard();
        }

        static boolean mav$detachAndSaveState(UndoState undoState) {
            return undoState.detachAndSaveState();
        }
    }
}

