/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.Timer;
import oracle.ide.util.AddinPolicyUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimedCache<K, V> {
    public static final int DEFAULT_EXPIRATION = 10;
    public static final int MAXIMUM_EXPIRATION = 1000;
    public static final int NEVER_EXPIRES = 0;
    private int defaultExpiration;
    private final HashMap cacheMap;
    private static final boolean DEBUG_OUTPUT = false;
    private static final int EXPIRATION_UNIT = 60000;

    public TimedCache() {
        this(10);
    }

    public TimedCache(int defaultExpiration) {
        this.setDefaultExpiration(defaultExpiration);
        this.cacheMap = new HashMap(5);
    }

    public V get(K key) {
        if (key == null) {
            throw new NullPointerException("get(): null key not allowed");
        }
        return (V)this.getFromCache(key);
    }

    public void put(K key, V value) {
        this.put(key, value, this.defaultExpiration);
    }

    public void put(K key, V value, int expiration) {
        if (key == null) {
            throw new NullPointerException("put(): null key not allowed");
        }
        if (value == null) {
            this.remove(key);
        } else {
            expiration = this.sanitizeExpiration(expiration);
            this.putIntoCache(key, value, expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry existingEntry = (Entry)this.cacheMap.remove(key);
            if (existingEntry != null) {
                Entry.mav$removeTimer(existingEntry);
            }
            Object object = existingEntry != null ? Entry.ra$cache(existingEntry) : null;
            return (V)object;
        }
    }

    public void setDefaultExpiration(int expiration) {
        this.defaultExpiration = this.sanitizeExpiration(expiration);
    }

    public void setExpiration(K key, int expiration) {
        if (key == null) {
            throw new NullPointerException("setExpire(): null key not allowed");
        }
        expiration = this.sanitizeExpiration(expiration);
        this.changeExpiration(key, expiration);
    }

    public void clear() {
        this.clearCache();
    }

    private int sanitizeExpiration(int expiration) {
        if ((expiration = Math.min(1000, expiration)) < 0) {
            expiration = 10;
        }
        return expiration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFromCache(Object key) {
        Object cache = null;
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry existingEntry = (Entry)this.cacheMap.get(key);
            if (existingEntry != null) {
                Entry.mav$restartTimer(existingEntry);
                cache = Entry.ra$cache(existingEntry);
            }
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putIntoCache(K key, V cache, int expiration) {
        Entry cacheEntry = new Entry(key, cache, expiration, null);
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry oldEntry = this.cacheMap.put(key, cacheEntry);
            if (oldEntry != null) {
                Entry.mav$removeTimer(oldEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache() {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Collection allEntries = this.cacheMap.values();
            for (Entry entry : allEntries) {
                if (entry == null) continue;
                Entry.mav$removeTimer(entry);
            }
            this.cacheMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeExpiration(K key, int expiration) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry existingEntry = (Entry)this.cacheMap.get(key);
            if (existingEntry != null) {
                Entry.mav$changeExpiration(existingEntry, expiration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entryExpired(Entry cacheEntry) {
        HashMap hashMap = this.cacheMap;
        synchronized (hashMap) {
            Entry existingEntry = (Entry)this.cacheMap.get(Entry.ra$key(cacheEntry));
            if (existingEntry == cacheEntry) {
                this.cacheMap.remove(Entry.ra$key(cacheEntry));
            }
            Entry.mav$removeTimer(cacheEntry);
        }
    }

    private static void debugPrint(String out) {
        System.out.print("Time: " + System.currentTimeMillis());
        System.out.print(" Thread: " + Thread.currentThread().toString());
        System.out.println(" Out: " + out);
    }

    static void mav$entryExpired(TimedCache timedCache, Entry entry) {
        timedCache.entryExpired(entry);
    }

    private final class Entry
    implements ActionListener {
        private Object key;
        private Object cache;
        private Timer timer;

        private Entry(Object key, Object cache, int expiration) {
            this.key = key;
            this.cache = cache;
            this.changeExpiration(expiration);
        }

        private void changeExpiration(int expiration) {
            if (expiration == 0) {
                this.removeTimer();
            } else {
                int delay = expiration * 60000;
                if (this.timer == null) {
                    this.timer = new Timer(delay, this);
                    this.timer.setRepeats(false);
                } else {
                    this.timer.setInitialDelay(delay);
                }
                this.restartTimer();
            }
        }

        private void restartTimer() {
            if (this.timer != null) {
                boolean wasWarning = AddinPolicyUtils.setWarnWhenCreatingThreads(false);
                this.timer.restart();
                AddinPolicyUtils.setWarnWhenCreatingThreads(wasWarning);
            }
        }

        private void removeTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer.removeActionListener(this);
                this.timer = null;
            }
        }

        public void actionPerformed(ActionEvent event) {
            TimedCache.mav$entryExpired(TimedCache.this, this);
        }

        static Object ra$key(Entry entry) {
            return entry.key;
        }

        static void mav$removeTimer(Entry entry) {
            entry.removeTimer();
        }

        static void mav$changeExpiration(Entry entry, int n) {
            entry.changeExpiration(n);
        }

        Entry(Object object, Object object2, int n, 1 var5_5) {
            this(object, object2, n);
        }

        static void mav$restartTimer(Entry entry) {
            entry.restartTimer();
        }

        static Object ra$cache(Entry entry) {
            return entry.cache;
        }

        public final class 1 {
        }
    }
}

