/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public final class GraphicsUtils
extends oracle.javatools.util.GraphicsUtils {
    private static final Insets HIGHLIGHT_INSETS = new Insets(1, 1, 1, 1);
    protected static final Component component = new 1();
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static Hashtable imageCache = new Hashtable();
    private static final String[] m_ImageExtensions = new File("A").equals(new File("a")) ? new String[]{".gif", ".jpg", ".jpeg", ".png"} : new String[]{".gif", ".GIF", ".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG"};

    private GraphicsUtils() {
    }

    public static void drawHighlightBorder(Graphics g, int x, int y, int width, int height, boolean raised, Color shadow, Color highlight) {
        Color oldColor = g.getColor();
        g.translate(x, y);
        g.setColor(raised ? highlight : shadow);
        g.drawLine(0, 0, width - 2, 0);
        g.drawLine(0, 1, 0, height - 2);
        g.setColor(raised ? shadow : highlight);
        g.drawLine(width - 1, 0, width - 1, height - 1);
        g.drawLine(0, height - 1, width - 2, height - 1);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    public static Insets getHighlightBorderInsets() {
        return HIGHLIGHT_INSETS;
    }

    public static ImageIcon createImageIcon(URL url) {
        if (url == null) {
            return null;
        }
        return GraphicsUtils.createImageIcon(Toolkit.getDefaultToolkit().createImage(url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon createImageIcon(Image image) {
        if (image == null) {
            return null;
        }
        MediaTracker mediaTracker = tracker;
        synchronized (mediaTracker) {
            tracker.addImage(image, 0);
            try {
                tracker.waitForID(0, 0L);
            }
            catch (InterruptedException e) {
                System.out.println("INTERRUPTED while loading Image");
            }
            tracker.removeImage(image, 0);
        }
        return new ImageIcon(image);
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, MouseEvent event) {
        Component source = (Component)event.getSource();
        Point topLeftSource = source.getLocationOnScreen();
        Point ptRet = GraphicsUtils.getPopupMenuShowPoint(popup, topLeftSource.x + event.getX(), topLeftSource.y + event.getY());
        ptRet.translate(-topLeftSource.x, -topLeftSource.y);
        return ptRet;
    }

    public static Point getPopupMenuShowPoint(JPopupMenu popup, int x, int y) {
        Dimension sizeMenu = popup.getPreferredSize();
        Point bottomRightMenu = new Point(x + sizeMenu.width, y + sizeMenu.height);
        Rectangle[] screensBounds = GraphicsUtils.getScreenBounds();
        int n = screensBounds.length;
        int i = 0;
        while (i < n) {
            Rectangle screenBounds = screensBounds[i];
            if (screenBounds.x <= x && x <= screenBounds.x + screenBounds.width) {
                Dimension sizeScreen = screenBounds.getSize();
                sizeScreen.height -= 32;
                int xOffset = 0;
                if (bottomRightMenu.x > screenBounds.x + sizeScreen.width) {
                    xOffset = -sizeMenu.width;
                }
                int yOffset = 0;
                if (bottomRightMenu.y > screenBounds.y + sizeScreen.height) {
                    yOffset = sizeScreen.height - bottomRightMenu.y;
                }
                return new Point(x + xOffset, y + yOffset);
            }
            ++i;
        }
        return new Point(x, y);
    }

    public static void centerWindowOnComponent(Window window, Component over) {
        if (over == null || !over.isShowing()) {
            GraphicsUtils.centerWindowOnScreen(window);
            return;
        }
        Point parentLocation = over.getLocationOnScreen();
        Dimension parentSize = over.getSize();
        Dimension size = window.getSize();
        int x = parentLocation.x + (parentSize.width - size.width) / 2;
        int y = parentLocation.y + (parentSize.height - size.height) / 2;
        Rectangle[] screenBounds = GraphicsUtils.getScreenBounds();
        Point ptCenter = new Point(x + size.width, y + size.height);
        int i = 0;
        while (i < screenBounds.length) {
            Rectangle screenBound = screenBounds[i];
            if (screenBound.contains(ptCenter)) {
                if (x + size.width > screenBound.width) {
                    x = screenBound.width - size.width;
                }
                if (x < screenBound.x) {
                    x = screenBound.x;
                }
                if (y + size.height > screenBound.height) {
                    y = screenBound.height - size.height;
                }
                if (y >= screenBound.y) break;
                y = screenBound.y;
                break;
            }
            ++i;
        }
        window.setLocation(x, y);
    }

    public static boolean isAncestorOfFocusedComponent(Component c) {
        Component focusedChildComponent = GraphicsUtils.getFocusedChildComponent(c);
        return focusedChildComponent != null;
    }

    public static Component getFocusedChildComponent(Component c) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getPermanentFocusOwner();
        if (focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, c)) {
            return focusOwner;
        }
        return null;
    }

    public static Component getFocusableComponentOrChild(Component c) {
        return GraphicsUtils.getFocusableComponentOrChild(c, false);
    }

    public static JComponent getFocusableComponentOrChild(Component c, boolean deepest) {
        if (c != null && c.isEnabled() && c.isVisible() && c instanceof JComponent) {
            JComponent jcomp = (JComponent)c;
            if (!deepest && jcomp.isFocusable() && jcomp.isRequestFocusEnabled() && !jcomp.getClass().getName().equals("javax.swing.JPanel")) {
                return jcomp;
            }
            int n = jcomp.getComponentCount();
            int i = 0;
            while (i < n) {
                Component child = jcomp.getComponent(i);
                JComponent focused = GraphicsUtils.getFocusableComponentOrChild(child, deepest);
                if (focused != null) {
                    return focused;
                }
                ++i;
            }
            if (deepest && jcomp.isFocusable() && jcomp.isRequestFocusEnabled() && !jcomp.getClass().getName().equals("javax.swing.JPanel")) {
                return jcomp;
            }
        }
        return null;
    }

    public static Component focusComponentOrChild(Component c) {
        return GraphicsUtils.focusComponentOrChild(c, false);
    }

    public static JComponent focusComponentOrChild(Component c, boolean deepest) {
        JComponent ret = null;
        JComponent focusable = GraphicsUtils.getFocusableComponentOrChild(c, deepest);
        if (focusable != null && focusable.requestFocusInWindow()) {
            ret = focusable;
        }
        return ret;
    }

    public static Image loadFromResource(String imageName, Class cls) {
        try {
            URL url = cls.getResource(imageName);
            if (url == null) {
                Image image = null;
                return image;
            }
            Image image = (Image)imageCache.get(url.toString());
            if (image == null) {
                image = Toolkit.getDefaultToolkit().createImage(url);
                imageCache.put(url.toString(), image);
            }
            Image image2 = image;
            return image2;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Rectangle[] getScreenBounds() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screenDevices = graphicsEnvironment.getScreenDevices();
        Rectangle[] ret = new Rectangle[screenDevices.length];
        int i = 0;
        while (i < screenDevices.length) {
            GraphicsDevice screenDevice = screenDevices[i];
            GraphicsConfiguration defaultConfiguration = screenDevice.getDefaultConfiguration();
            Rectangle screenBounds = defaultConfiguration.getBounds();
            Insets screenInsets = toolkit.getScreenInsets(defaultConfiguration);
            screenBounds.width -= Math.abs(screenInsets.left + screenInsets.right);
            screenBounds.height -= Math.abs(screenInsets.top + screenInsets.bottom);
            screenBounds.x += Math.abs(screenInsets.left);
            screenBounds.y += Math.abs(screenInsets.top);
            ret[i] = screenBounds;
            ++i;
        }
        return ret;
    }

    public static String[] getImageExtensions() {
        return m_ImageExtensions;
    }

    static final class 1
    extends Component {
    }
}

