/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.util.ModelUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class EncodingsData {
    private ArrayList _encodingsList;
    private HashMap _jdk2iana;

    private void $init$() {
        this._encodingsList = new ArrayList();
        this._jdk2iana = new HashMap();
    }

    public EncodingsData(File encodingsFile) throws IOException {
        this.$init$();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().parse(encodingsFile);
            this.processEncodings(doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public EncodingsData() {
        this.$init$();
    }

    public List getEncodingsList() {
        return this._encodingsList;
    }

    public Map getJdk2IanaMap() {
        return this._jdk2iana;
    }

    private void processEncodings(Element elem) {
        ChildIter iter = new ChildIter(elem);
        while (iter.hasNext()) {
            Element childElem = iter.nextElem();
            String tagName = childElem.getTagName();
            if ("iana".equals(tagName)) {
                this.processIana(childElem);
                continue;
            }
            if (!"sun-jdk".equals(tagName)) continue;
            this.processSunJdk(childElem);
        }
    }

    private void processIana(Element elem) {
        ChildIter iter = new ChildIter(elem);
        while (iter.hasNext()) {
            Element childElem = iter.nextElem();
            String tagName = childElem.getTagName();
            if (!"cs".equals(tagName)) continue;
            this.processCs(childElem);
        }
    }

    private void processCs(Element elem) {
        this.addEncoding(elem.getAttribute("name"));
        this.addEncoding(elem.getAttribute("preferred-mime-name"));
        ChildIter iter = new ChildIter(elem);
        block0: while (iter.hasNext()) {
            Element aliasElem = iter.nextElem();
            String tagName = aliasElem.getTagName();
            if (!"alias".equals(tagName)) continue;
            NodeList aliasNodes = aliasElem.getChildNodes();
            int n = aliasNodes.getLength();
            int i = 0;
            while (i < n) {
                String aliasObj;
                Node aliasChildNode = aliasNodes.item(i);
                if (aliasChildNode.getNodeType() == 3 && (aliasObj = aliasChildNode.getNodeValue()) != null) {
                    this.addEncoding(aliasObj.toString());
                    continue block0;
                }
                ++i;
            }
        }
    }

    private void addEncoding(String encoding) {
        if (ModelUtil.hasLength(encoding)) {
            this._encodingsList.add(encoding);
        }
    }

    private void processSunJdk(Element elem) {
        ChildIter iter = new ChildIter(elem);
        while (iter.hasNext()) {
            Element childElem = iter.nextElem();
            String tagName = childElem.getTagName();
            if (!"jdk2iana".equals(tagName)) continue;
            this.processJdk2Iana(childElem);
        }
    }

    private void processJdk2Iana(Element elem) {
        String jdkName = elem.getAttribute("jdk");
        String ianaName = elem.getAttribute("iana");
        if (ModelUtil.hasLength(jdkName)) {
            this.addEncoding(jdkName);
            if (ModelUtil.hasLength(ianaName)) {
                this._jdk2iana.put(jdkName.toUpperCase(), ianaName);
            }
        }
    }

    private static class ChildIter {
        private final NodeList _nodes;
        private final int _n;
        private int _i;
        private Element _nextElem;

        ChildIter(Node node) {
            this._nodes = node.getChildNodes();
            this._n = this._nodes.getLength();
            this._i = 0;
        }

        public boolean hasNext() {
            this.seekNext();
            return this._nextElem != null;
        }

        public Element nextElem() {
            this.seekNext();
            Element elem = this._nextElem;
            this._nextElem = null;
            return elem;
        }

        private void seekNext() {
            if (this._nextElem == null) {
                while (this._i < this._n) {
                    Node node;
                    if ((node = this._nodes.item(this._i++)).getNodeType() != 1) continue;
                    this._nextElem = (Element)node;
                    return;
                }
            }
        }
    }
}

