/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.util.HashMap;
import java.util.Stack;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.ide.util.HogTracker;

public final class Assert {
    private static final Logger LOGGER = Logger.getLogger(Assert.class.getName());
    private static HashMap _timingMap;
    private static HashMap _trackerMap;
    private static final String CHECKING_PROPERTY = "ide.AssertCheckingDisabled";
    private static final boolean checking;
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing;
    private static int timingThreshold;

    static {
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(new AssertHandler());
        _timingMap = new HashMap();
        _trackerMap = new HashMap();
        checking = Boolean.getBoolean(CHECKING_PROPERTY) ^ true;
        tracing = Boolean.getBoolean(TRACING_PROPERTY) ^ true;
        timingThreshold = -2;
    }

    private Assert() {
    }

    public static void precondition(boolean condition, String description) throws PreconditionException {
        if (checking && !condition) {
            throw new PreconditionException(description);
        }
    }

    public static void precondition(boolean condition) throws PreconditionException {
        if (checking && !condition) {
            throw new PreconditionException();
        }
    }

    public static void check(boolean condition, String description) throws CheckException {
        if (checking && !condition) {
            throw new CheckException(description);
        }
    }

    public static void check(boolean condition) throws CheckException {
        if (checking && !condition) {
            throw new CheckException();
        }
    }

    public static void checkAWTThread() throws CheckException {
    }

    public static void fail(String description) throws CheckException {
    }

    public static void fail() throws CheckException {
    }

    public static void fail(Exception ex) throws CheckException {
    }

    public static void exit(int code) {
        System.exit(code);
    }

    public static void printStackTrace() {
    }

    public static void printStackTrace(Throwable ex) {
        ex.printStackTrace(System.err);
    }

    public static void printStackTrace(boolean condition, String s) {
        if (!condition || s != null) {
            // empty if block
        }
    }

    public static void print(String s) {
        if (tracing) {
            System.err.print("Assert: " + s);
        }
    }

    public static void print(boolean condition, String s) {
        if (condition) {
            // empty if block
        }
    }

    public static void print(boolean condition, String trueString, String falseString) {
        if (!condition) {
            // empty if block
        }
    }

    public static void println(String s) {
        if (tracing) {
            LOGGER.fine(s);
        }
    }

    public static void println(boolean condition, String s) {
        if (condition) {
            // empty if block
        }
    }

    public static void println(boolean condition, String trueString, String falseString) {
        if (!condition) {
            // empty if block
        }
    }

    public static void println(String pattern, Object param) {
    }

    public static void println(String pattern, Object param1, Object param2) {
    }

    public static void println(String pattern, Object param1, Object param2, Object param3) {
    }

    public static void println(String pattern, Object[] params) {
    }

    public static void execute(Runnable runnable) {
        runnable.run();
    }

    private static String getTimingKey(String key) {
        return Thread.currentThread().getName() + ":" + key;
    }

    public static void startTiming(String key, String msg, boolean quietStart) {
    }

    public static synchronized void startTiming(String key, String msg, boolean quietStart, boolean prefixThread) {
        if (quietStart) {
            return;
        }
        String storeKey = prefixThread ? Assert.getTimingKey(key) : key;
        _timingMap.put(storeKey, new Long(System.nanoTime()));
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart) {
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart, long timeThreshold) {
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread) {
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread, long timeThreshold) {
        String storeKey;
        if (quietStart) {
            return;
        }
        long endTime = System.nanoTime();
        String string = storeKey = prefixThread ? Assert.getTimingKey(key) : key;
        if (msg != null) {
            if (!_timingMap.containsKey(storeKey)) {
                return;
            }
            long startTime = (Long)_timingMap.get(storeKey);
            long msElapsed = (endTime - startTime) / 1000000L;
        }
        _timingMap.remove(storeKey);
    }

    public static void printTiming(long time, String msg, String indent) {
    }

    public static void printTiming(long time, String msg, String indent, long threshold) {
        if (time >= threshold && time > (long)Assert.printTimingThreshold()) {
            StringBuffer sb = new StringBuffer(10 + msg.length());
            sb.append("[").append(time).append("ms] ");
            while (sb.length() < 11) {
                sb.insert(0, " ");
            }
            if (indent == null || indent.length() == 0) {
                sb.append(msg);
            } else {
                sb.append(indent).append(msg);
            }
        }
    }

    public static void printHeader(String msg) {
        if (msg != null) {
            // empty if block
        }
    }

    public static int printTimingThreshold() {
        if (timingThreshold == -2) {
            try {
                timingThreshold = Integer.valueOf(System.getProperty("PrintTimingThreshold", "50"));
                if (timingThreshold < 0) {
                    timingThreshold = -1;
                }
            }
            catch (Exception e) {
                timingThreshold = -1;
            }
        }
        return timingThreshold;
    }

    public static synchronized void startTracking(String key) {
        String storeKey = Assert.getTimingKey(key);
        Stack<HogTracker> stack = (Stack<HogTracker>)_trackerMap.get(storeKey);
        if (stack == null) {
            stack = new Stack<HogTracker>();
            _trackerMap.put(storeKey, stack);
        }
        stack.push(new HogTracker());
    }

    public static void markTracking(String key) {
        HogTracker tracker = Assert.getTracker(key, false);
        if (tracker != null) {
            tracker.mark();
        }
    }

    public static void checkTracking(String key, Object object) {
        HogTracker tracker = Assert.getTracker(key, false);
        if (tracker != null) {
            tracker.check(object);
        }
    }

    public static void endTracking(String key) {
    }

    public static void endTracking(String key, String msg) {
        HogTracker tracker = Assert.getTracker(key, true);
        if (tracker != null) {
            tracker.report();
            if (msg != null && msg.length() > 0) {
                tracker.reportTotal(msg);
            }
        }
    }

    private static synchronized HogTracker getTracker(String key, boolean remove) {
        String storeKey = Assert.getTimingKey(key);
        if (!_trackerMap.containsKey(storeKey)) {
            return null;
        }
        Stack stack = (Stack)_trackerMap.get(storeKey);
        if (remove) {
            HogTracker tracker = (HogTracker)stack.pop();
            if (stack.size() == 0) {
                _trackerMap.remove(key);
            }
            return tracker;
        }
        return (HogTracker)stack.peek();
    }

    static class PreconditionException
    extends IllegalStateException {
        PreconditionException() {
        }

        PreconditionException(String message) {
            super(message);
        }
    }

    static class CheckException
    extends IllegalStateException {
        CheckException() {
            this("Check failed");
        }

        CheckException(String message) {
            super(message);
        }
    }

    private static class AssertHandler
    extends ConsoleHandler {
        AssertHandler() {
            this.setLevel(Level.FINE);
            if (!Boolean.getBoolean("ide.assert.standardFormatter")) {
                this.setFormatter(new AssertFormatter(null));
            }
        }
    }

    private static class AssertFormatter
    extends Formatter {
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            b.append("Trace: ");
            b.append(record.getMessage());
            b.append("\n");
            return b.toString();
        }

        private AssertFormatter() {
        }

        AssertFormatter(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

