/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;

public class AddinPolicyUtils {
    private static Object[] m_ExceptionList = new Object[0];
    private static String POLICY_VIOLATION = "Addin Policy Violation!";
    private static final String CREATING_IMAGE_ICON_POLICY_CHECK_ID = "CREATING_IMAGE_ICON_POLICY_CHECK";
    private static final String CREATING_THREAD_POLICY_CHECK_ID = "CREATING_THREAD_POLICY_CHECK";
    private static final Object ERROR_REPORTED = new Object();
    private static HashMap m_CommandIDNStackTracePairToJMenuItem = new HashMap();
    private static final boolean OVERRIDE_FLAG = Boolean.getBoolean("oracle.ide.util.AddinPolicyUtils.OVERRIDE_FLAG");
    private static boolean m_WarnWhenCreatingImageIcons = false;
    private static boolean m_WarnWhenCreatingThreads = false;
    private static boolean m_WarnWhenLeakingJMenuItems = true;

    public static void initializingAddins(boolean initializing) {
        if (!initializing) {
            // empty if block
        }
        AddinPolicyUtils.setWarnWhenCreatingImageIcons(initializing);
        AddinPolicyUtils.setWarnWhenCreatingThreads(initializing);
    }

    public static void creatingImageIconPolicyCheck() {
        if (OVERRIDE_FLAG || m_WarnWhenCreatingImageIcons) {
            // empty if block
        }
    }

    public static void creatingThreadPolicyCheck() {
        String stackTrace;
        if (OVERRIDE_FLAG || !m_WarnWhenCreatingThreads || (stackTrace = AddinPolicyUtils.getStackTrace(new Exception())).indexOf("java.awt.EventQueue.initDispatchThread") != -1 || stackTrace.indexOf("sun.awt.AWTAutoShutdown.activateBlockerThread") != -1 || stackTrace.indexOf("java.util.logging.LogManager.<clinit>") != -1 || stackTrace.indexOf("java.lang.UNIXProcess.<init>") == -1) {
            // empty if block
        }
    }

    public static void creatingAbstractButtonLeakPolicyCheck(AbstractButton abstractButton) {
        if (!OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingLocalActionLeakPolicyCheck(Action action) {
        if (!OVERRIDE_FLAG) {
            // empty if block
        }
    }

    public static void creatingJMenuItemLeakPolicyCheck(JMenuItem menuItem, int commandID) {
        if (!OVERRIDE_FLAG && m_WarnWhenLeakingJMenuItems) {
            CommandIDNStackTracePair key = new CommandIDNStackTracePair(commandID);
            Object value = m_CommandIDNStackTracePairToJMenuItem.get(key);
            if (value != null) {
                if (value == ERROR_REPORTED) {
                    return;
                }
                value = ((WeakReference)value).get();
            }
            if (value != null && ((AbstractButton)value).getAction() != null) {
                m_CommandIDNStackTracePairToJMenuItem.put(key, ERROR_REPORTED);
                String addInClassName = AddinPolicyUtils.getAddInClassName(key.m_StackTrace);
                if ("oracle.bm.addinUtil.ModelAddin".equals(addInClassName)) {
                    return;
                }
                System.err.println(POLICY_VIOLATION);
                System.err.print(key.m_StackTrace);
                return;
            }
            m_CommandIDNStackTracePairToJMenuItem.put(key, new WeakReference<JMenuItem>(menuItem));
        }
    }

    public static boolean setWarnWhenCreatingThreads(boolean warn) {
        boolean wasWarnWhenCreatingThreads = m_WarnWhenCreatingThreads;
        m_WarnWhenCreatingThreads = warn;
        return wasWarnWhenCreatingThreads;
    }

    public static boolean setWarnWhenCreatingImageIcons(boolean warn) {
        boolean wasWarnWhenCreatingImageIcons = m_WarnWhenCreatingImageIcons;
        m_WarnWhenCreatingImageIcons = warn;
        return wasWarnWhenCreatingImageIcons;
    }

    public static boolean setWarnWhenLeakingJMenuItems(boolean warn) {
        boolean wasWarnWhenLeakingJMenuItems = m_WarnWhenLeakingJMenuItems;
        m_WarnWhenLeakingJMenuItems = warn;
        return wasWarnWhenLeakingJMenuItems;
    }

    public static void runRunnable(Runnable runnable) {
        runnable.run();
    }

    public static void applicationExiting() {
    }

    public static void checkCallStackForPolicyViolation(String violationMethod, String method) {
        String stackTrace;
        if (!OVERRIDE_FLAG && (stackTrace = AddinPolicyUtils.getStackTrace(new Exception())).indexOf(violationMethod) != -1) {
            System.err.println(POLICY_VIOLATION);
            System.err.println(method + " called directly or indirectly from " + violationMethod);
            System.err.print(stackTrace);
        }
    }

    public static void ensureGarbageCollectable(Object obj) {
    }

    public static void ensureGarbageCollectable(Object obj, int seconds) {
        Thread t = new Thread((Runnable)new MemoryLeakChecker(seconds, obj, null), "Leak detector for " + obj);
        t.setDaemon(true);
        t.start();
    }

    private AddinPolicyUtils() {
    }

    private static String getStackTrace(Throwable throwable) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(charArrayWriter));
        String result = charArrayWriter.toString();
        charArrayWriter.close();
        return result;
    }

    private static String getAddInClassName(String stackTrace) {
        String addInName = null;
        StringTokenizer stringTokenizer = new StringTokenizer(stackTrace, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            int atSpaceIndex;
            String token = stringTokenizer.nextToken();
            int initializeIndex = token.indexOf(".initialize");
            if (initializeIndex == -1) continue;
            if (!stringTokenizer.hasMoreTokens() || stringTokenizer.nextToken().indexOf("oracle.ide.AddinManager.initializeAddin") == -1 || (atSpaceIndex = token.indexOf("at ")) == -1) break;
            addInName = token.substring(atSpaceIndex + 3, initializeIndex);
            break;
        }
        return addInName;
    }

    private static void printInitializationViolationMessage(String message, String POLICY_CHECK_ID) {
        String stackTrace = AddinPolicyUtils.getStackTrace(new Exception(message));
        if (m_ExceptionList.length > 0) {
            String addInClassName = AddinPolicyUtils.getAddInClassName(stackTrace);
            if (addInClassName == null) {
                System.err.println("AddinPolicyUtils BUG: COULD NOT IDENTIFY ADDIN NAME.");
            } else {
                int i = 0;
                while (i < m_ExceptionList.length) {
                    if (addInClassName.equals(m_ExceptionList[i]) && POLICY_CHECK_ID == m_ExceptionList[i + 1]) {
                        return;
                    }
                    i += 2;
                }
            }
        }
        System.err.println(POLICY_VIOLATION);
        System.err.print(stackTrace);
    }

    static String maS$getStackTrace(Throwable throwable) {
        return AddinPolicyUtils.getStackTrace(throwable);
    }

    private static class MemoryLeakChecker
    implements Runnable {
        private final int _numSeconds;
        private final WeakReference _ref;
        private final String _objToString;

        public void run() {
            int i = 1;
            while (i < this._numSeconds) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object got = this._ref.get();
                if (got == null) {
                    return;
                }
                got = null;
                System.gc();
                ++i;
            }
        }

        private MemoryLeakChecker(int numSeconds, Object o) {
            this._numSeconds = numSeconds;
            this._objToString = o.toString();
            this._ref = new WeakReference<Object>(o);
        }

        MemoryLeakChecker(int n, Object object, 1 var3_3) {
            this(n, object);
        }

        public final class 1 {
        }
    }

    private static class CommandIDNStackTracePair {
        public final int m_CommandID;
        public final String m_StackTrace;

        public CommandIDNStackTracePair(int commandID) {
            this.m_CommandID = commandID;
            this.m_StackTrace = AddinPolicyUtils.maS$getStackTrace(new Exception("A memory leak is occurring since a temporary AbstractButton (JMenuItem or JButton usually) was created and the action was not set to null."));
        }

        public boolean equals(Object anObject) {
            if (anObject instanceof CommandIDNStackTracePair) {
                CommandIDNStackTracePair cmpElem = (CommandIDNStackTracePair)anObject;
                return this.m_CommandID == cmpElem.m_CommandID && this.m_StackTrace.equals(cmpElem.m_StackTrace);
            }
            return false;
        }

        public int hashCode() {
            return this.m_StackTrace.hashCode() + this.m_CommandID;
        }
    }
}

