/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.NetArb;
import oracle.ide.util.ModelUtil;

public class WildcardURLFilter
implements URLFilter {
    private final Pattern _pattern;
    private final String _description;

    public WildcardURLFilter(String wildcard) {
        this(wildcard, URLFileSystem.isLocalFileSystemCaseSensitive());
    }

    public WildcardURLFilter(String wildcard, boolean isCaseSensitive) {
        this(wildcard, isCaseSensitive, NetArb.getString(21));
    }

    public WildcardURLFilter(String wildcard, boolean isCaseSensitive, String description) {
        String regexp = WildcardURLFilter.wildcard2Regexp(wildcard);
        Pattern pattern = null;
        try {
            pattern = isCaseSensitive ? Pattern.compile(regexp) : Pattern.compile(regexp, 2);
        }
        catch (PatternSyntaxException e) {
            e.printStackTrace();
        }
        this._pattern = pattern;
        this._description = NetArb.format(29, description, wildcard);
    }

    public boolean accept(URL url) {
        return this.match(URLFileSystem.getFileName(url));
    }

    protected boolean match(String str) {
        return this._pattern != null ? this._pattern.matcher(str).matches() : true;
    }

    public static boolean hasWildcard(String expression) {
        return expression != null && (expression.indexOf("*") >= 0 || expression.indexOf("?") >= 0);
    }

    public static String wildcard2Regexp(String wildcard) {
        if (wildcard == null) {
            return null;
        }
        StringBuffer regexp = new StringBuffer("^");
        char[] chars = wildcard.toCharArray();
        int n = chars.length;
        int i = 0;
        while (i < n) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c)) {
                regexp.append(c);
            } else if (c == '\\') {
                regexp.append('\\');
                if (++i < n) {
                    regexp.append(chars[i]);
                }
            } else if (c == '*' || c == '?') {
                regexp.append('.').append(c);
            } else {
                regexp.append('\\').append(c);
            }
            ++i;
        }
        regexp.append("$");
        return regexp.toString();
    }

    public static String makeLiteral(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer escaped = new StringBuffer();
        char[] chars = string.toCharArray();
        int n = chars.length;
        int i = 0;
        while (i < n) {
            char c = chars[i];
            if (Character.isLetterOrDigit(c)) {
                escaped.append(c);
            } else {
                escaped.append('\\').append(c);
            }
            ++i;
        }
        return escaped.toString();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((WildcardURLFilter)o);
    }

    protected final boolean equalsImpl(WildcardURLFilter filter) {
        return ModelUtil.areEqual(this._pattern, filter._pattern) && ModelUtil.areEqual(this._description, filter._description);
    }

    public String toString() {
        return this._description;
    }
}

