/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLPath
extends DefaultSubDirtyable
implements Copyable,
Iterable<URL> {
    private final List _entriesList;

    public URLPath() {
        this._entriesList = new ArrayList();
    }

    public URLPath(int initialCapacity) {
        this._entriesList = new ArrayList(initialCapacity);
    }

    public URLPath(URL entry) {
        this();
        this.add(entry);
    }

    public URLPath(URL[] entries) {
        this();
        this.add(entries);
    }

    public URLPath(ListStructure entries) {
        this((List)entries);
    }

    public URLPath(List entries) {
        if (entries != null) {
            for (Object obj : entries) {
                if (obj == null) {
                    throw new IllegalArgumentException("The specified List contains null.");
                }
                if (obj instanceof URL) continue;
                throw new IllegalArgumentException("The specified List contains a non-URL object (" + obj.getClass().toString() + ")");
            }
            this._entriesList = entries;
        } else {
            this._entriesList = new ArrayList();
        }
    }

    public URLPath(URLPath urlPath) {
        this();
        if (urlPath != null) {
            urlPath.copyToImpl(this);
        }
    }

    @Override
    public Object copyTo(Object object) {
        URLPath copy = object != null ? (URLPath)object : new URLPath();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(URLPath copy) {
        copy._entriesList.clear();
        copy._entriesList.addAll(this._entriesList);
    }

    public void add(URL entry) {
        if (entry != null && !this.contains(entry)) {
            this._entriesList.add(entry);
            this.markDirty(true);
        }
    }

    public void add(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            int i = 0;
            while (i < numEntries) {
                this.add(entries[i]);
                ++i;
            }
        }
    }

    public void add(Collection entries) {
        if (entries != null) {
            for (Object obj : entries) {
                if (!(obj instanceof URL)) continue;
                this.add((URL)obj);
            }
        }
    }

    public void add(List entries) {
        this.add((Collection)entries);
    }

    public void add(URLPath urlPath) {
        if (urlPath != null) {
            this.add(urlPath.getEntries());
        }
    }

    public List asList() {
        return Collections.unmodifiableList(this._entriesList);
    }

    public URL[] getEntries() {
        return this._entriesList.toArray(new URL[this._entriesList.size()]);
    }

    public boolean contains(URL entry) {
        return this.findEntry(entry) >= 0;
    }

    public List getAllDirectories() {
        URL[] entries = this.getEntries();
        HashSet dirList = new HashSet();
        int i = 0;
        while (i < entries.length) {
            this._getAllDirectories(entries[i], entries[i], dirList, URLFileSystem.findHelper(entries[i]));
            ++i;
        }
        ArrayList list = new ArrayList(dirList);
        Collections.sort(list);
        return list;
    }

    public void expandToIncludeManifestClassPaths() {
        int i = 0;
        HashSet processedJars = new HashSet();
        while (i < this._entriesList.size()) {
            URL curEntry = (URL)this._entriesList.get(i++);
            i = this.expandToIncludeManifestClassPathImpl(i, curEntry, processedJars);
        }
    }

    private int expandToIncludeManifestClassPathImpl(int insertionPoint, URL curEntry, Set processedJars) {
        if ("".equals(JarUtil.getJarEntry(curEntry)) && !processedJars.contains(curEntry)) {
            processedJars.add(curEntry);
            try {
                String manifestClassPath = JarUtil.getClassPath(curEntry);
                if (manifestClassPath != null) {
                    URL jarFileURL = JarUtil.getJarFileURL(curEntry);
                    URL dirURL = URLFileSystem.getParent(jarFileURL);
                    StringTokenizer st = new StringTokenizer(manifestClassPath);
                    while (st.hasMoreTokens()) {
                        URL manifestCpItemURL;
                        String manifestCpItem = st.nextToken();
                        boolean isJar = false;
                        URL newJarFileURL = null;
                        if (JarUtil.isArchive(manifestCpItem)) {
                            isJar = true;
                            newJarFileURL = URLFactory.newURL(dirURL, manifestCpItem);
                            manifestCpItemURL = URLFactory.newJarURL(newJarFileURL, null);
                        } else {
                            manifestCpItemURL = URLFactory.newURL(dirURL, manifestCpItem);
                        }
                        if (!URLFileSystem.exists(isJar ? newJarFileURL : manifestCpItemURL)) continue;
                        if (!this._entriesList.contains(manifestCpItemURL)) {
                            this._entriesList.add(insertionPoint++, manifestCpItemURL);
                        }
                        if (!isJar) continue;
                        insertionPoint = this.expandToIncludeManifestClassPathImpl(insertionPoint, manifestCpItemURL, processedJars);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return insertionPoint;
    }

    public List getDirectories(String relPath) {
        return this.getDirectories(relPath, null);
    }

    public List getDirectories(String relPath, URLFilter urlFilter) {
        ArrayList list = new ArrayList();
        if (relPath != null) {
            HashSet<String> dirList = new HashSet<String>();
            String prefix = relPath.length() == 0 || relPath.endsWith("/") ? relPath : relPath + "/";
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL entry = URLFactory.newDirURL(entries[i], relPath);
                URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                if (infos != null) {
                    int j = 0;
                    while (j < infos.length) {
                        URLFileSystem.FileInfo info = infos[j];
                        if (info.isDirectory()) {
                            URL newURL = info.getURL();
                            dirList.add(prefix + helper.getFileName(newURL));
                        }
                        ++j;
                    }
                }
                ++i;
            }
            list.addAll(dirList);
            Collections.sort(list);
        }
        return list;
    }

    public List getFiles(String relPath) {
        return this.getFiles(relPath, null);
    }

    public List getFiles(String relPath, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL entry = URLFactory.newDirURL(entries[i], relPath);
                URLFileSystem.FileInfo[] infos = URLFileSystem.ls(entry, urlFilter);
                if (infos != null) {
                    int j = 0;
                    while (j < infos.length) {
                        URLFileSystem.FileInfo info = infos[j];
                        if (info.isFile()) {
                            URL newURL = info.getURL();
                            fileList.add(newURL);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            Collections.sort(fileList, new URLComparator());
        }
        return fileList;
    }

    public List getFilesAndDirectories(String relPath, boolean dirsBeforeFiles) {
        return this.getFilesAndDirectories(relPath, dirsBeforeFiles, null);
    }

    public List getFilesAndDirectories(String relPath, boolean dirsBeforeFiles, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL entry = URLFactory.newDirURL(entries[i], relPath);
                URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                if (infos != null) {
                    int j = 0;
                    while (j < infos.length) {
                        URL newURL = infos[j].getURL();
                        fileList.add(newURL);
                        ++j;
                    }
                }
                ++i;
            }
            Collections.sort(fileList, new URLComparator(dirsBeforeFiles));
        }
        return fileList;
    }

    public URL getFirstEntry() {
        if (this._entriesList.size() > 0) {
            return (URL)this._entriesList.get(0);
        }
        return null;
    }

    public static URLPath getURLPath(HashStructure hash, String urlPathName) {
        URLPath urlPath = new URLPath();
        if (hash != null) {
            try {
                ListStructure list = hash.getListStructure(urlPathName);
                urlPath.add(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urlPath;
    }

    public static boolean setURLPath(HashStructure hash, String urlPathName, URLPath urlPath) {
        if (hash != null) {
            try {
                if (urlPath != null) {
                    ListStructure list = hash.getOrCreateListStructure(urlPathName);
                    boolean bl = list.mirror(urlPath.asList());
                    return bl;
                }
                if (hash.containsKey(urlPathName)) {
                    hash.remove(urlPathName);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public Iterator<URL> iterator() {
        return this._entriesList.iterator();
    }

    public static URLPath newURLPathFromString(String entries) {
        URLPath urlPath = new URLPath();
        if (entries != null) {
            StringTokenizer tokenizer = new StringTokenizer(entries, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                URL url = URLPath.pathToURL(path);
                urlPath.add(url);
            }
        }
        return urlPath;
    }

    public void remove(URL entry) {
        int i;
        if (entry != null && (i = this.findEntry(entry)) >= 0) {
            this._entriesList.remove(i);
            this.markDirty(true);
        }
    }

    public void remove(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            int i = 0;
            while (i < numEntries) {
                this.remove(entries[i]);
                ++i;
            }
        }
    }

    public void remove(URLPath urlPath) {
        if (urlPath != null) {
            this.remove(urlPath.getEntries());
        }
    }

    public void setEntries(URL[] entries) {
        this._entriesList.clear();
        if (entries != null) {
            this.add(entries);
        }
        this.markDirty(true);
    }

    public int size() {
        return this._entriesList.size();
    }

    private boolean isArchive(URL url) {
        return ".zip".equalsIgnoreCase(URLFileSystem.getSuffix(url)) || ".jar".equalsIgnoreCase(URLFileSystem.getSuffix(url));
    }

    public URL toQualifiedURL(String relativePath) {
        URL[] urls = this.toQualifiedURL(relativePath, true);
        if (urls == null) {
            return null;
        }
        return urls[0];
    }

    public URL[] toQualifiedURL(String relativePath, boolean firstMatch) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (relativePath != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL pathElem = entries[i];
                URL fullURL = pathElem.getProtocol().equals("jar") ? URLFactory.newJarURL(pathElem, relativePath) : (this.isArchive(pathElem) ? URLFactory.newJarURL(pathElem, relativePath) : URLFactory.newURL(pathElem, relativePath));
                if (URLFileSystem.exists(fullURL)) {
                    urlList.add(fullURL);
                    if (firstMatch) break;
                }
                ++i;
            }
        }
        if (urlList.size() == 0) {
            return null;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public URL toBoundURL(String relativePath) {
        if (relativePath != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL pathElem = entries[i];
                URL fullURL = pathElem.getProtocol().equals("jar") ? URLFactory.newJarURL(pathElem, relativePath) : URLFactory.newURL(pathElem, relativePath);
                if (URLFileSystem.isBound(fullURL)) {
                    return fullURL;
                }
                ++i;
            }
        }
        return null;
    }

    public String toRelativePath(URL url) {
        if (url != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                URL pathElem = entries[i];
                String relativePath = URLFileSystem.toRelativeSpec(url, pathElem, true);
                if (relativePath != null) {
                    return relativePath;
                }
                ++i;
            }
        }
        return null;
    }

    public String toShortestRelativePath(URL url) {
        URL longestMatch = this.getLongestMatchingEntry(url);
        if (longestMatch != null) {
            return URLFileSystem.toRelativeSpec(url, longestMatch, true);
        }
        return null;
    }

    public URL getLongestMatchingEntry(URL url) {
        if (url != null) {
            String urlString = url.toString();
            URL[] entries = this.getEntries();
            String longestMatch = null;
            URL longestURL = null;
            int i = 0;
            while (i < entries.length) {
                URL entry = entries[i];
                String entryString = entry.toString();
                if (urlString.startsWith(entryString) && (longestMatch == null || entryString.length() > longestMatch.length())) {
                    longestMatch = entryString;
                    longestURL = entry;
                }
                ++i;
            }
            return longestURL;
        }
        return null;
    }

    public String[] toStrings() {
        URL[] entries = this.getEntries();
        String[] result = new String[entries.length];
        int i = 0;
        while (i < entries.length) {
            String path;
            URL url = entries[i];
            result[i] = path = URLFileSystem.getPlatformPathName(url);
            ++i;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URLPath)o);
    }

    protected final boolean equalsImpl(URLPath urlPath) {
        if (this == urlPath) {
            return true;
        }
        if (this._entriesList.size() != urlPath._entriesList.size()) {
            return false;
        }
        Iterator iter1 = this._entriesList.iterator();
        Iterator iter2 = urlPath._entriesList.iterator();
        while (iter1.hasNext()) {
            URL url2;
            URL url1 = (URL)iter1.next();
            if (URLFileSystem.equals(url1, url2 = (URL)iter2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer urlPath = new StringBuffer();
        URL[] entries = this.getEntries();
        int i = 0;
        while (i < entries.length) {
            URL url = entries[i];
            String path = URLFileSystem.getPlatformPathName(url);
            urlPath.append(path).append(File.pathSeparatorChar);
            ++i;
        }
        int len = urlPath.length();
        if (len > 0) {
            urlPath.setLength(len - 1);
        }
        return urlPath.toString();
    }

    public boolean validateAllEntriesExist() {
        URL[] entries = this.getEntries();
        if (entries == null) {
            return true;
        }
        int i = 0;
        while (i < entries.length) {
            if (!URLFileSystem.exists(entries[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private int findEntry(URL entry) {
        if (entry != null) {
            URL[] entries = this.getEntries();
            int i = 0;
            while (i < entries.length) {
                if (URLFileSystem.equals(entry, entries[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private static URL pathToURL(String pathname) {
        if (JarUtil.isArchive(pathname) && new File(pathname).isFile()) {
            URL url = URLFactory.newFileURL(pathname);
            return URLFactory.newJarURL(url, "");
        }
        URL dirURL = URLFactory.newDirURL(pathname);
        return URLFileSystem.canonicalize(dirURL);
    }

    private void _getAllDirectories(URL baseURL, URL currentURL, Set dirList, URLFileSystemHelper helper) {
        URLFileSystem.FileInfo[] infos = helper.ls(currentURL);
        if (infos != null) {
            String relPath = helper.toRelativeSpec(currentURL, baseURL);
            if (relPath != null && relPath.length() > 0) {
                dirList.add(relPath);
            }
            int i = 0;
            while (i < infos.length) {
                URLFileSystem.FileInfo info = infos[i];
                if (info.isDirectory()) {
                    this._getAllDirectories(baseURL, info.getURL(), dirList, helper);
                }
                ++i;
            }
        }
    }
}

