/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.Icon;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.net.URLFilter;
import oracle.ide.resource.IdeIcons;

public class URLFileSystemHelper {
    static final String ICON_KEY_DIRECTORY = "FileView.directoryIcon";
    static final String ICON_KEY_FILE = "FileView.fileIcon";

    protected URLFileSystemHelper() {
    }

    public URL canonicalize(URL url) {
        return url;
    }

    public boolean canRead(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection != null) {
                boolean bl = urlConnection.getDoInput();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean canWrite(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection != null) {
                boolean bl = urlConnection.getDoOutput();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
    }

    public boolean canCreate(URL url) {
        return true;
    }

    public boolean canDelete(URL url) {
        return this.exists(url) && !this.isReadOnly(url);
    }

    public boolean isValid(URL url) {
        if (this.exists(url)) {
            return true;
        }
        return this.canCreate(url);
    }

    public URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        String newPath;
        String path = url.getPath();
        if (path.endsWith(oldSuffix)) {
            int suffixIndex = path.length() - oldSuffix.length();
            newPath = path.substring(0, suffixIndex) + newSuffix;
        } else {
            newPath = path + newSuffix;
        }
        return URLFactory.replacePathPart(url, newPath);
    }

    public void delete(URL url) throws IOException {
    }

    public URL ensureSuffix(URL url, String suffix) {
        if (this.hasSuffix(url, suffix)) {
            return url;
        }
        String path = url.getPath();
        return URLFactory.replacePathPart(url, path + suffix);
    }

    public boolean equals(URL url1, URL url2) {
        return this.haveSameHost(url1, url2) && this.haveSamePort(url1, url2) && this.haveSamePath(url1, url2) && this.haveSameQuery(url1, url2) && this.haveSameRef(url1, url2) && this.haveSameUserInfo(url1, url2);
    }

    public boolean exists(URL url) {
        return false;
    }

    public Icon getDefaultIcon(URL url) {
        if (URLFileSystem.isDirectoryPath(url)) {
            return IdeIcons.getIcon(26);
        }
        return IdeIcons.getIcon(28);
    }

    public String getFileName(URL url) {
        if (url == null) {
            return "";
        }
        String path = url.getPath();
        if (path == null || path.length() == 0) {
            return "";
        }
        if (path.equals("/")) {
            return "/";
        }
        int lastSep = path.lastIndexOf(47);
        if (lastSep == path.length() - 1) {
            int lastSep2 = path.lastIndexOf(47, lastSep - 1);
            return path.substring(lastSep2 + 1, lastSep);
        }
        return path.substring(lastSep + 1);
    }

    public long getLength(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection != null) {
                long l = urlConnection.getContentLength();
                return l;
            }
            long l = -1;
            return l;
        }
        catch (Exception e) {
            long l = -1;
            return l;
        }
    }

    public String getName(URL url) {
        String fileName = this.getFileName(url);
        int firstDot = fileName.lastIndexOf(46);
        return firstDot > 0 ? fileName.substring(0, firstDot) : fileName;
    }

    public URL getParent(URL url) {
        URL ret = URLFactory.newURL(url, "..");
        return (ret = URLFactory.newURL(ret.getProtocol(), ret.getUserInfo(), ret.getHost(), ret.getPort(), ret.getPath(), null, null)) != null && !URLFileSystem.equals(url, ret) ? ret : null;
    }

    public String getPath(URL url) {
        return url.getPath();
    }

    public String getPathNoExt(URL url) {
        String path = this.getPath(url);
        int lastSlash = path.lastIndexOf("/");
        int lastDot = path.lastIndexOf(".");
        if (lastDot <= lastSlash) {
            return path;
        }
        return path.substring(0, lastDot);
    }

    public String getPlatformPathName(URL url) {
        return url != null ? url.toString() : "";
    }

    public String getSuffix(URL url) {
        String path = url.getPath();
        int lastDot = path.lastIndexOf(46);
        int lastSlash = path.lastIndexOf(47);
        return lastDot >= 0 && lastDot > lastSlash ? path.substring(lastDot) : "";
    }

    public String getSystemDisplayName(URL url) {
        return URLFileSystem.getFileName(url);
    }

    public Icon getSystemIcon(URL url) {
        return URLFileSystem.getDefaultIcon(url);
    }

    public boolean hasSuffix(URL url, String suffix) {
        String path = url.getPath();
        return path.endsWith(suffix);
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        if (!this.isDirectoryPath(url1)) {
            return false;
        }
        String url1String = url1.toString();
        String url2String = url2.toString();
        return url2String.startsWith(url1String);
    }

    public boolean isDirectory(URL url) {
        return false;
    }

    public boolean isDirectoryPath(URL url) {
        return url != null && url.getPath().endsWith("/") && url.getQuery() == null && url.getRef() == null;
    }

    public boolean isHidden(URL url) {
        return false;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public boolean isRegularFile(URL url) {
        return this.exists(url) && !this.isDirectory(url);
    }

    public long lastModified(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            if (urlConnection != null) {
                long l = urlConnection.getLastModified();
                return l;
            }
            long l = -1;
            return l;
        }
        catch (Exception e) {
            long l = -1;
            return l;
        }
    }

    public URL[] list(URL url) {
        return new URL[0];
    }

    public void verifyList(URL url) throws IOException {
    }

    public URL[] list(URL url, URLFilter filter) {
        URL[] list = this.list(url);
        if (list == null) {
            return null;
        }
        if (filter == null) {
            return list;
        }
        ArrayList<URL> filteredList = new ArrayList<URL>();
        int i = list.length - 1;
        while (i >= 0) {
            URL fileURL = list[i];
            if (filter.accept(fileURL)) {
                filteredList.add(fileURL);
            }
            --i;
        }
        return filteredList.toArray(new URL[filteredList.size()]);
    }

    public URL[] list(URL url, URLFilenameFilter filter) {
        if (filter == null) {
            return this.list(url);
        }
        1 urlFilter = new 1(this, filter, url);
        return this.list(url, urlFilter);
    }

    public URL[] listRoots() {
        return null;
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return this.ls(url, null);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        return this.lsCached(url, null);
    }

    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        URL[] urls = URLFileSystem.list(url, filter);
        if (urls == null) {
            return null;
        }
        URLFileSystem.FileInfo[] infos = new URLFileSystem.FileInfo[urls.length];
        int i = 0;
        while (i < urls.length) {
            infos[i] = new URLFileSystem.FileInfo(urls[i]);
            ++i;
        }
        return infos;
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        return this.ls(url, filter);
    }

    public boolean mkdir(URL url) {
        return false;
    }

    public boolean mkdirs(URL url) {
        return false;
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return null;
    }

    public InputStream openInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn == null) {
            throw new IOException("No connection");
        }
        return conn.getInputStream();
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn == null) {
            throw new IOException("No connection");
        }
        return conn.getOutputStream();
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
    }

    public boolean setLastModified(URL url, long time) {
        return false;
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        return false;
    }

    public String toDisplayString(URL url) {
        return url == null ? "" : url.toString();
    }

    public String toEncodedString(URL url) {
        return this.toEncodedString(url, null);
    }

    public String toEncodedString(URL url, String encoding) {
        URL encodedURL = URLFactory.encodeURL(url, encoding);
        return encodedURL != null ? encodedURL.toString() : "";
    }

    public String toRelativeSpec(URL url, URL base) {
        return this.toRelativeSpec(url, base, false);
    }

    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        if (!this.haveSameProtocol(url, base) || !this.haveSameAuthority(url, base)) {
            return mustConsumeBase ? null : url.toString();
        }
        StringBuffer relativeURL = new StringBuffer();
        boolean baseFullyConsumed = this.appendRelativePath(url, base, relativeURL, mustConsumeBase);
        if (mustConsumeBase && !baseFullyConsumed) {
            return null;
        }
        return relativeURL.toString();
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        String basePath = url.getPath();
        int basePathIndex = basePath.lastIndexOf(47);
        if (basePathIndex < basePath.length() - 1) {
            url = this.getParent(url);
            basePath = url.getPath();
        }
        String baseDir = basePath.substring(0, basePathIndex);
        int relPathIndex = relativeSpec.lastIndexOf(47);
        if (relPathIndex < 0) {
            return url;
        }
        String relDir = relativeSpec.substring(0, relativeSpec.lastIndexOf(47));
        StringTokenizer relTokenizer = new StringTokenizer(relDir, "/");
        String relToken = relTokenizer.nextToken();
        StringTokenizer baseTokenizer = new StringTokenizer(baseDir, "/");
        int ctr = 0;
        boolean foundBasePath = false;
        while (baseTokenizer.hasMoreTokens()) {
            String baseToken = baseTokenizer.nextToken();
            if (this.areEqualPathElems(relToken, baseToken)) {
                int relCount;
                int baseCount = baseTokenizer.countTokens();
                if (baseCount != (relCount = relTokenizer.countTokens())) continue;
                if (relCount != 0) {
                    relToken = relTokenizer.nextToken();
                    ++ctr;
                    continue;
                }
                foundBasePath = true;
                break;
            }
            if (ctr == 0) continue;
            ctr = 0;
            break;
        }
        if (foundBasePath) {
            int i = ctr;
            while (i >= 0) {
                url = this.getParent(url);
                --i;
            }
        }
        return url;
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        InputStream inputStream = null;
        InputStreamReader isr = null;
        try {
            inputStream = URLFileSystem.openInputStream(url);
            isr = new InputStreamReader(inputStream, encoding);
        }
        finally {
            if (isr == null && inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception ex) {}
            }
        }
        return isr;
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
    }

    protected boolean haveSameUserInfo(URL url1, URL url2) {
        return this.areEqual(url1.getUserInfo(), url2.getUserInfo());
    }

    protected boolean haveSameHost(URL url1, URL url2) {
        return this.areEqual(url1.getHost(), url2.getHost());
    }

    protected boolean haveSamePath(URL url1, URL url2) {
        return this.areEqual(url1.getPath(), url2.getPath());
    }

    protected boolean haveSameQuery(URL url1, URL url2) {
        return this.areEqual(url1.getQuery(), url2.getQuery());
    }

    protected boolean haveSameRef(URL url1, URL url2) {
        return this.areEqual(url1.getRef(), url2.getRef());
    }

    protected boolean haveSamePort(URL url1, URL url2) {
        return url1.getPort() == url2.getPort();
    }

    protected final boolean areEqual(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    protected boolean haveSameProtocol(URL url, URL base) {
        if (url == null || base == null) {
            return false;
        }
        String urlProtocol = url.getProtocol();
        String baseProtocol = base.getProtocol();
        return urlProtocol.equals(baseProtocol);
    }

    protected boolean haveSameAuthority(URL url, URL base) {
        if (url == base) {
            return true;
        }
        if (url == null || base == null) {
            return false;
        }
        String urlAuthority = url.getAuthority();
        String baseAuthority = base.getAuthority();
        if (urlAuthority == null) {
            return baseAuthority == null;
        }
        if (baseAuthority != null) {
            return urlAuthority.equals(baseAuthority);
        }
        return false;
    }

    protected boolean appendRelativePath(URL url, URL base, StringBuffer relativeURL, boolean mustConsumeBase) {
        boolean baseFullyConsumed;
        String urlPath = url.getPath();
        int urlLastSlash = urlPath.lastIndexOf(47);
        String urlDir = urlLastSlash >= 0 ? urlPath.substring(0, urlLastSlash) : "";
        String urlFileName = urlPath.substring(urlLastSlash + 1);
        StringTokenizer urlTokenizer = new StringTokenizer(urlDir, "/");
        String basePath = base.getPath();
        String baseDir = basePath.substring(0, basePath.lastIndexOf(47));
        StringTokenizer baseTokenizer = new StringTokenizer(baseDir, "/");
        int numBaseTokens = baseTokenizer.countTokens();
        int numMatches = 0;
        String urlToken = null;
        while (urlTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens()) {
            String baseToken;
            urlToken = urlTokenizer.nextToken();
            if (!this.areEqualPathElems(urlToken, baseToken = baseTokenizer.nextToken())) break;
            ++numMatches;
            urlToken = null;
        }
        boolean bl = baseFullyConsumed = numBaseTokens == numMatches;
        if (mustConsumeBase && !baseFullyConsumed) {
            return false;
        }
        if (numMatches == 0) {
            relativeURL.append(urlPath);
        } else {
            int numDotDotsNeeded;
            int i = numDotDotsNeeded = numBaseTokens - numMatches;
            while (i > 0) {
                relativeURL.append("../");
                --i;
            }
            if (urlToken != null && urlToken.length() > 0) {
                if (numDotDotsNeeded == 0 && urlToken.indexOf(58) >= 0) {
                    relativeURL.append("./");
                }
                relativeURL.append(urlToken).append('/');
            }
            while (urlTokenizer.hasMoreTokens()) {
                relativeURL.append(urlTokenizer.nextToken()).append('/');
            }
            relativeURL.append(urlFileName);
        }
        return baseFullyConsumed;
    }

    protected boolean areEqualPathElems(String urlElem, String baseElem) {
        return urlElem.equals(baseElem);
    }

    final class 1
    implements URLFilter {
        private final /* synthetic */ URLFilenameFilter v$filter;
        private final /* synthetic */ URL v$url;
        final /* synthetic */ URLFileSystemHelper this$0;

        public boolean accept(URL childUrl) {
            String name = this.this$0.getFileName(childUrl);
            return this.v$filter.accept(this.v$url, name);
        }

        public 1(URLFileSystemHelper uRLFileSystemHelper, URLFilenameFilter uRLFilenameFilter, URL uRL) {
            this.v$url = uRL;
            this.v$filter = uRLFilenameFilter;
            this.this$0 = uRLFileSystemHelper;
        }
    }
}

