/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import oracle.ide.boot.URLStreamHandlerFactoryQueue;
import oracle.ide.net.CodeSourceURLFileSystemHelper;
import oracle.ide.net.FileURLFileSystemHelper;
import oracle.ide.net.HttpURLFileSystemHelper;
import oracle.ide.net.IdeDisplayURLFileSystemHelper;
import oracle.ide.net.IdeURLFileSystemHelper;
import oracle.ide.net.JarURLFileSystemHelper;
import oracle.ide.net.ProtocolConstants;
import oracle.ide.net.URLExistsTest;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemEvent;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.net.URLFilter;

public final class URLFileSystem {
    private static final HashMap _helpers = new HashMap();
    private static final URLFileSystemHelper _defaultHelper = new URLFileSystemHelper();
    private static final ArrayList _existsTests = new ArrayList(3);
    private static final boolean _isCaseSensitive;
    private static final HashMap _rootURLToFrontListenerMap;
    private static final HashMap _rootURLToListenerMap;
    private static boolean TRACE_DANGLING_STREAMS;
    private static HashSet _seenMalformedDirURLs;

    static {
        URLFileSystem.registerHelper("file", new FileURLFileSystemHelper());
        URLFileSystem.registerHelper("jar", new JarURLFileSystemHelper());
        URLFileSystem.registerHelper("http", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("https", new HttpURLFileSystemHelper());
        URLFileSystem.registerHelper("ide", new IdeURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.display", new IdeDisplayURLFileSystemHelper());
        URLFileSystem.registerHelper("ide.text", new IdeURLFileSystemHelper());
        URLFileSystem.registerHelper("code-source", new CodeSourceURLFileSystemHelper());
        File f1 = new File("A");
        File f2 = new File("a");
        _isCaseSensitive = f1.equals(f2) ^ true;
        _rootURLToFrontListenerMap = new HashMap(500);
        _rootURLToListenerMap = new HashMap(500);
        TRACE_DANGLING_STREAMS = false;
        3 var2_2 = new 3();
        _seenMalformedDirURLs = new HashSet();
    }

    private URLFileSystem() {
    }

    public static void registerHelper(String protocol, URLFileSystemHelper helper) {
        if (protocol != null && protocol.length() > 0 && helper != null) {
            _helpers.put(protocol, helper);
            if (ProtocolConstants.isIdeProtocol(protocol)) {
                ProtocolConstants.addIdeProtocol(protocol);
            }
        }
    }

    public static URLFileSystemHelper findHelper(String protocol) {
        Object helper = _helpers.get(protocol);
        if (helper == null && ProtocolConstants.isIdeProtocol(protocol)) {
            int index = protocol.lastIndexOf(".");
            while (index > 0) {
                String head = protocol.substring(0, index);
                helper = _helpers.get(head);
                if (helper != null) break;
                protocol = head;
                index = protocol.lastIndexOf(".");
            }
        }
        return helper != null ? (URLFileSystemHelper)helper : _defaultHelper;
    }

    public static URLFileSystemHelper findHelper(URL url) {
        if (url == null) {
            return _defaultHelper;
        }
        String protocol = url.getProtocol();
        return URLFileSystem.findHelper(protocol);
    }

    public static void addExistsTest(URLExistsTest existsTest) {
        if (existsTest != null) {
            _existsTests.add(existsTest);
        }
    }

    public static void addURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        URLStreamHandlerFactoryQueue.addFactory(factory);
    }

    public static URL canonicalize(URL url) {
        return URLFileSystem.findHelper(url).canonicalize(url);
    }

    public static boolean canRead(URL url) {
        return URLFileSystem.findHelper(url).canRead(url);
    }

    public static boolean canWrite(URL url) {
        return URLFileSystem.findHelper(url).canWrite(url);
    }

    public static boolean canCreate(URL url) {
        return URLFileSystem.findHelper(url).canCreate(url);
    }

    public static boolean canDelete(URL url) {
        return URLFileSystem.findHelper(url).canDelete(url);
    }

    public static boolean isValid(URL url) {
        return URLFileSystem.findHelper(url).isValid(url);
    }

    public static URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        return URLFileSystem.findHelper(url).convertSuffix(url, oldSuffix, newSuffix);
    }

    public static void copy(URL src, URL dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = URLFileSystem.openInputStream(src);
            out = URLFileSystem.openOutputStream(dst);
            if (!URLFileSystem.mkdirs(URLFileSystem.getParent(dst))) {
                throw new IOException();
            }
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void copy(InputStream in, URL dst) throws IOException {
        OutputStream out = null;
        try {
            out = URLFileSystem.openOutputStream(dst);
            URLFileSystem.mkdirs(URLFileSystem.getParent(dst));
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public static void copy(URL src, File dst) throws IOException {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = URLFileSystem.openInputStream(src);
            File parentDir = dst.getParentFile();
            if (parentDir != null) {
                parentDir.mkdirs();
            }
            out = new FileOutputStream(dst);
            URLFileSystem.copy(in, out);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }

    public static boolean delete(URL url) {
        try {
            URLFileSystem.deleteEx(url);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
    }

    public static void deleteEx(URL url) throws IOException {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        boolean isTrackedURL = rootURL != null;
        boolean notifyFile = isTrackedURL && helper.isRegularFile(url);
        boolean notifyDir = isTrackedURL && !notifyFile && helper.isDirectory(url);
        helper.delete(url);
        if (notifyFile || notifyDir) {
            int eventType = notifyFile ? 3 : 11;
            URLFileSystem.fireURLFileSystemEvent(url, eventType);
        }
    }

    public static URL ensureSuffix(URL url, String suffix) {
        return URLFileSystem.findHelper(url).ensureSuffix(url, suffix);
    }

    public static boolean equals(URL url1, URL url2) {
        if (url1 == url2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(url1, url2)) {
            return false;
        }
        return URLFileSystem.findHelper(url1).equals(url1, url2);
    }

    public static boolean exists(URL url) {
        return URLFileSystem.findHelper(url).exists(url);
    }

    public static Icon getDefaultIcon(URL url) {
        return URLFileSystem.findHelper(url).getDefaultIcon(url);
    }

    public static String getFileName(URL url) {
        return URLFileSystem.findHelper(url).getFileName(url);
    }

    public static long getLength(URL url) {
        return URLFileSystem.findHelper(url).getLength(url);
    }

    public static String getName(URL url) {
        return URLFileSystem.findHelper(url).getName(url);
    }

    public static URL getParent(URL url) {
        return URLFileSystem.findHelper(url).getParent(url);
    }

    public static String getPath(URL url) {
        return URLFileSystem.findHelper(url).getPath(url);
    }

    public static String getPathNoExt(URL url) {
        return URLFileSystem.findHelper(url).getPathNoExt(url);
    }

    public static String getPlatformPathName(URL url) {
        return URLFileSystem.findHelper(url).getPlatformPathName(url);
    }

    public static String getSuffix(URL url) {
        return URLFileSystem.findHelper(url).getSuffix(url);
    }

    public static String getSystemDisplayName(URL url) {
        return URLFileSystem.findHelper(url).getSystemDisplayName(url);
    }

    public static Icon getSystemIcon(URL url) {
        return URLFileSystem.findHelper(url).getSystemIcon(url);
    }

    public static boolean hasSuffix(URL url, String suffix) {
        return URLFileSystem.findHelper(url).hasSuffix(url, suffix);
    }

    public static boolean hasSuffix(URL url, String[] suffixs) {
        URLFileSystemHelper urlFileSystemHelper = URLFileSystem.findHelper(url);
        int i = 0;
        while (i < suffixs.length) {
            if (urlFileSystemHelper.hasSuffix(url, suffixs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isBaseURLFor(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        if (url1 == url2) {
            return true;
        }
        if (!URLFileSystem.protocolsAreEqual(url1, url2)) {
            return false;
        }
        return URLFileSystem.findHelper(url1).isBaseURLFor(url1, url2);
    }

    public static boolean isBound(URL url) {
        for (URLExistsTest test : _existsTests) {
            if (!test.urlExists(url)) continue;
            return true;
        }
        return URLFileSystem.exists(url);
    }

    public static boolean isLocal(URL url) {
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        return "file".equalsIgnoreCase(protocol) || "jar".equalsIgnoreCase(protocol);
    }

    public static boolean isLocalFileSystemCaseSensitive() {
        return _isCaseSensitive;
    }

    public static boolean isDirectory(URL url) {
        return URLFileSystem.findHelper(url).isDirectory(url);
    }

    public static boolean isDirectoryPath(URL url) {
        return URLFileSystem.findHelper(url).isDirectoryPath(url);
    }

    public static boolean isHidden(URL url) {
        return URLFileSystem.findHelper(url).isHidden(url);
    }

    public static boolean isReadOnly(URL url) {
        return URLFileSystem.findHelper(url).isReadOnly(url);
    }

    public static boolean isRegularFile(URL url) {
        return URLFileSystem.findHelper(url).isRegularFile(url);
    }

    public static boolean isRoot(URL url) {
        if (url == null) {
            return false;
        }
        URL[] roots = URLFileSystem.listRoots();
        int n = roots.length;
        int i = 0;
        while (i < n) {
            if (URLFileSystem.equals(url, roots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static URL[] listRoots() {
        ArrayList<URL> roots = new ArrayList<URL>(40);
        ArrayList helperKeys = new ArrayList(_helpers.keySet());
        Collections.sort(helperKeys);
        Iterator iter = helperKeys.iterator();
        while (iter.hasNext()) {
            String protocol = iter.next().toString();
            URLFileSystemHelper helper = (URLFileSystemHelper)_helpers.get(protocol);
            URL[] protocolRoots = helper.listRoots();
            if (protocolRoots == null) continue;
            roots.addAll(Arrays.asList(protocolRoots));
        }
        return roots.toArray(new URL[roots.size()]);
    }

    public static long lastModified(URL url) {
        return URLFileSystem.findHelper(url).lastModified(url);
    }

    public static URL[] list(URL url) {
        return URLFileSystem.findHelper(url).list(url);
    }

    public static URL[] list(URL url, URLFilter filter) {
        return URLFileSystem.findHelper(url).list(url, filter);
    }

    public static URL[] list(URL url, URLFilenameFilter filter) {
        if (url == null) {
            throw new NullPointerException("url is null");
        }
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).list(url, filter);
    }

    public static FileInfo[] ls(URL url) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).ls(url);
    }

    public static FileInfo[] ls(URL url, URLFilter filter) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).ls(url, filter);
    }

    public static FileInfo[] lsCached(URL url) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).lsCached(url);
    }

    public static FileInfo[] lsCached(URL url, URLFilter filter) {
        url = URLFileSystem.assertIsDirURL(url);
        return URLFileSystem.findHelper(url).lsCached(url, filter);
    }

    public static boolean mkdir(URL url) {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url = URLFileSystem.assertIsDirURL(url));
        boolean success = helper.mkdir(url);
        if (success) {
            URLFileSystem.fireURLFileSystemEvent(url, 10);
        }
        return success;
    }

    public static boolean mkdirs(URL url) {
        url = URLFileSystem.assertIsDirURL(url);
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        List intermediateList = URLFileSystem.getNonExistentParents(rootURL, url);
        boolean success = helper.mkdirs(url);
        URLFileSystem.notifyExistentParents(rootURL, intermediateList);
        if (success) {
            URLFileSystem.fireURLFileSystemEvent(url, 10);
        }
        return success;
    }

    public static URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return directory != null ? URLFileSystem.findHelper(directory).createTempFile(prefix, suffix, directory) : URLFileSystem.findHelper("file").createTempFile(prefix, suffix, null);
    }

    public static InputStream openInputStream(URL url) throws IOException {
        return URLFileSystem.findHelper(url).openInputStream(url);
    }

    public static OutputStream openOutputStream(URL url) throws IOException {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        List intermediateList = URLFileSystem.getNonExistentParents(rootURL, url);
        boolean notify = rootURL != null;
        boolean existed = notify && helper.isRegularFile(url);
        try {
            OutputStream stream = helper.openOutputStream(url);
            if (notify) {
                if (stream != null) {
                    1 notifier = new 1(existed, rootURL, intermediateList, url);
                    stream = new TrackedOutputStream(notifier, stream);
                } else {
                    URLFileSystem.notifyExistentParents(rootURL, intermediateList);
                }
            }
            OutputStream outputStream = stream;
            return outputStream;
        }
        catch (IOException e) {
            URLFileSystem.notifyExistentParents(rootURL, intermediateList);
            throw e;
        }
    }

    public static boolean renameTo(URL oldURL, URL newURL) {
        try {
            URLFileSystem.renameEx(oldURL, newURL);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
    }

    public static void renameEx(URL oldURL, URL newURL) throws IOException {
        if (oldURL == null || newURL == null) {
            throw new IOException("URLFileSystem.renameEx: Null URL parameter");
        }
        if (oldURL == newURL || oldURL.equals(newURL)) {
            throw new IOException("URLFileSystem.renameEx: URL parameters are equal");
        }
        if (!URLFileSystem.protocolsAreEqual(oldURL, newURL)) {
            URLFileSystem.copy(oldURL, newURL);
            URLFileSystem.deleteEx(oldURL);
        }
        URLFileSystemHelper helper = URLFileSystem.findHelper(oldURL);
        URL oldRootURL = URLFileSystem.getTrackedRootURL(oldURL);
        URL newRootURL = URLFileSystem.getTrackedRootURL(newURL);
        boolean oldTracking = oldRootURL != null;
        boolean newTracking = newRootURL != null;
        boolean notifyFile = oldTracking && helper.isRegularFile(oldURL);
        boolean notifyDir = oldTracking && !notifyFile && helper.isDirectory(oldURL);
        List intermediateList = URLFileSystem.getNonExistentParents(newRootURL, newURL);
        boolean success = false;
        try {
            helper.rename(oldURL, newURL);
            success = true;
        }
        catch (Throwable throwable) {
            try {
                if (oldTracking || newTracking) {
                    URLFileSystem.notifyExistentParents(newRootURL, intermediateList);
                    if (success && (notifyFile || notifyDir)) {
                        int eventType = notifyFile ? 4 : 12;
                        URLFileSystem.fireRenameURLFileSystemEvent(newURL, oldURL, eventType);
                    }
                }
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            throw throwable;
        }
        try {
            if (oldTracking || newTracking) {
                URLFileSystem.notifyExistentParents(newRootURL, intermediateList);
                if (success && (notifyFile || notifyDir)) {
                    int eventType = notifyFile ? 4 : 12;
                    URLFileSystem.fireRenameURLFileSystemEvent(newURL, oldURL, eventType);
                }
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean setLastModified(URL url, long time) {
        URLFileSystemHelper helper = URLFileSystem.findHelper(url);
        URL rootURL = URLFileSystem.getTrackedRootURL(url);
        boolean notify = rootURL != null && helper.isRegularFile(url);
        long oldTime = notify ? URLFileSystem.lastModified(url) : 0L;
        boolean success = helper.setLastModified(url, time);
        if (success && notify && oldTime != time) {
            URLFileSystem.fireURLFileSystemEvent(url, 2);
        }
        return success;
    }

    public static boolean setReadOnly(URL url, boolean readOnly) {
        return URLFileSystem.findHelper(url).setReadOnly(url, readOnly);
    }

    public static String toDisplayString(URL url) {
        return URLFileSystem.findHelper(url).toDisplayString(url);
    }

    public static String toEncodedString(URL url) {
        return URLFileSystem.findHelper(url).toEncodedString(url, null);
    }

    public static String toEncodedString(URL url, String encoding) {
        return URLFileSystem.findHelper(url).toEncodedString(url, encoding);
    }

    public static String toRelativeSpec(URL url, URL base) {
        return URLFileSystem.findHelper(url).toRelativeSpec(url, base);
    }

    public static String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        return URLFileSystem.findHelper(url).toRelativeSpec(url, base, mustConsumeBase);
    }

    public static URL getBaseParent(URL url, String relativeSpec) {
        return URLFileSystem.findHelper(url).getBaseParent(url, relativeSpec);
    }

    public static Reader createReader(URL url, String encoding) throws IOException {
        return URLFileSystem.findHelper(url).createReader(url, encoding);
    }

    private static boolean protocolsAreEqual(URL url1, URL url2) {
        if (url1 == null || url2 == null) {
            return false;
        }
        String p1 = url1.getProtocol();
        String p2 = url2.getProtocol();
        return p1.equals(p2);
    }

    protected static void fireURLFileSystemEvent(URL changedURL, int eventType) {
        if (changedURL == null) {
            return;
        }
        List rootList = URLFileSystem.getTrackedRootURLs(changedURL);
        URLFileSystem.fireURLFileSystemEvent(rootList, changedURL, null, eventType);
    }

    protected static void fireRenameURLFileSystemEvent(URL newURL, URL oldURL, int eventType) {
        if (newURL == null || oldURL == null) {
            return;
        }
        List oldRootList = URLFileSystem.getTrackedRootURLs(oldURL);
        List newRootList = URLFileSystem.getTrackedRootURLs(newURL);
        HashSet rootSet = new HashSet(oldRootList.size() + newRootList.size());
        rootSet.addAll(oldRootList);
        rootSet.addAll(newRootList);
        ArrayList rootList = new ArrayList(rootSet);
        URLFileSystem.fireURLFileSystemEvent(rootList, newURL, oldURL, eventType);
    }

    private static void fireURLFileSystemEvent(List rootURLs, URL changedURL, URL oldURL, int eventType) {
        if (changedURL == null || rootURLs == null || rootURLs.size() == 0) {
            return;
        }
        if (!URLFileSystemEvent.isValidEventType(eventType)) {
            return;
        }
        Map listenerToURLsMap = URLFileSystem.getListenersAndTrackedRootURLs(rootURLs);
        for (URLFileSystemListener listener : listenerToURLsMap.keySet()) {
            List registeredURLsList = (List)listenerToURLsMap.get(listener);
            URL[] registeredURLs = registeredURLsList.toArray(new URL[registeredURLsList.size()]);
            URLFileSystemEvent event = new URLFileSystemEvent(registeredURLs, changedURL, oldURL, eventType);
            try {
                listener.notifyEvent(event);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static URL getTrackedRootURL(URL url) {
        if (url != null) {
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                for (URL rootURL : _rootURLToListenerMap.keySet()) {
                    if (rootURL == null || !URLFileSystem.isBaseURLFor(rootURL, url)) continue;
                    URL uRL = rootURL;
                    return uRL;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Map getListenersAndTrackedRootURLs(List rootURLs) {
        if (rootURLs != null) {
            HashMap listenerMap = new HashMap();
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                int numRoots = rootURLs.size();
                int i = 0;
                while (i < numRoots) {
                    URL rootURL = (URL)rootURLs.get(i);
                    CopyOnWriteArrayList listenerList = (CopyOnWriteArrayList)_rootURLToListenerMap.get(rootURL);
                    if (listenerList != null) {
                        int listenerCount = listenerList.size();
                        int listenerIndex = 0;
                        while (listenerIndex < listenerCount) {
                            Object listener = listenerList.get(listenerIndex);
                            if (listener != null) {
                                ArrayList<URL> resultList = (ArrayList<URL>)listenerMap.get(listener);
                                if (resultList == null) {
                                    resultList = new ArrayList<URL>();
                                    listenerMap.put(listener, resultList);
                                }
                                resultList.add(rootURL);
                            }
                            ++listenerIndex;
                        }
                    }
                    ++i;
                }
            }
            return listenerMap;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List getTrackedRootURLs(URL url) {
        if (url != null) {
            ArrayList<URL> rootList = new ArrayList<URL>();
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                for (URL rootURL : _rootURLToListenerMap.keySet()) {
                    if (rootURL == null || !URLFileSystem.isBaseURLFor(rootURL, url)) continue;
                    rootList.add(rootURL);
                }
            }
            return rootList;
        }
        return null;
    }

    protected static List getNonExistentParents(URL rootURL, URL url) {
        ArrayList<URL> intermediateList = new ArrayList<URL>();
        if (rootURL != null) {
            URL parentURL;
            URL checkURL = url;
            while (!URLFileSystem.equals(checkURL, rootURL) && (parentURL = URLFileSystem.getParent(checkURL)) != null && !URLFileSystem.isDirectory(parentURL)) {
                intermediateList.add(parentURL);
                checkURL = parentURL;
            }
        }
        return intermediateList;
    }

    protected static void notifyExistentParents(URL rootURL, List intermediateList) {
        if (rootURL != null && intermediateList != null) {
            int count = intermediateList.size();
            int i = count - 1;
            while (i >= 0) {
                URL url = (URL)intermediateList.get(i);
                URLFileSystem.fireURLFileSystemEvent(url, 10);
                --i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        if (rootURL != null && listener != null) {
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                CopyOnWriteArrayList<URLFileSystemListener> listenerList = (CopyOnWriteArrayList<URLFileSystemListener>)_rootURLToListenerMap.get(rootURL);
                if (listenerList == null) {
                    listenerList = new CopyOnWriteArrayList<URLFileSystemListener>();
                    _rootURLToListenerMap.put(rootURL, listenerList);
                    2 frontListener = new 2(rootURL);
                    _rootURLToFrontListenerMap.put(rootURL, frontListener);
                    URLFileSystem.findHelper(rootURL).addURLFileSystemListener(rootURL, frontListener);
                }
                listenerList.addIfAbsent(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        if (rootURL != null && listener != null) {
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                CopyOnWriteArrayList listenerList = (CopyOnWriteArrayList)_rootURLToListenerMap.get(rootURL);
                if (listenerList != null && listenerList.contains(listener)) {
                    listenerList.remove(listener);
                    if (listenerList.isEmpty()) {
                        _rootURLToListenerMap.remove(rootURL);
                        URLFileSystemListener frontListener = (URLFileSystemListener)_rootURLToFrontListenerMap.remove(rootURL);
                        URLFileSystem.findHelper(rootURL).removeURLFileSystemListener(rootURL, frontListener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getURLsForListener(URLFileSystemListener listener) {
        if (listener != null) {
            ArrayList<URL> urls = new ArrayList<URL>();
            HashMap hashMap = _rootURLToListenerMap;
            synchronized (hashMap) {
                for (URL url : _rootURLToListenerMap.keySet()) {
                    List listenerList;
                    if (url == null || (listenerList = (List)_rootURLToListenerMap.get(url)) == null || !listenerList.contains(listener)) continue;
                    urls.add(url);
                }
            }
            return urls;
        }
        return Collections.EMPTY_LIST;
    }

    private static URL assertIsDirURL(URL url) {
        String path;
        if (url != null && (path = url.getPath()) != null && path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            if (!_seenMalformedDirURLs.contains(url)) {
                _seenMalformedDirURLs.add(url);
                new IllegalArgumentException("A non-directory URL was passed to an URLFileSystem method that requires a directory URL.  You must use URLFactory.newDirURL(..) instead of newURL(..) to create directory URLs: " + path).printStackTrace();
            }
            return URLFactory.replacePathPart(url, path + "/");
        }
        return url;
    }

    static boolean ra$TRACE_DANGLING_STREAMS() {
        return TRACE_DANGLING_STREAMS;
    }

    static HashMap ra$_rootURLToListenerMap() {
        return _rootURLToListenerMap;
    }

    static void wa$TRACE_DANGLING_STREAMS(boolean bl) {
        TRACE_DANGLING_STREAMS = bl;
    }

    static final class 1
    implements Runnable {
        private final /* synthetic */ boolean v$existed;
        private final /* synthetic */ URL v$rootURL;
        private final /* synthetic */ List v$intermediateList;
        private final /* synthetic */ URL v$url;

        public void run() {
            int eventType = this.v$existed ? 2 : 1;
            URLFileSystem.notifyExistentParents(this.v$rootURL, this.v$intermediateList);
            URLFileSystem.fireURLFileSystemEvent(this.v$url, eventType);
        }

        public 1(boolean bl, URL uRL, List list, URL uRL2) {
            this.v$url = uRL2;
            this.v$intermediateList = list;
            this.v$rootURL = uRL;
            this.v$existed = bl;
        }
    }

    public static class FileInfo {
        protected static final int ATTR_DIRECTORY = 1;
        protected static final int ATTR_REGULAR = 2;
        protected static final int ATTR_HIDDEN = 4;
        protected URL url;
        protected int attributes;
        protected long lastModified;
        protected long length;

        protected FileInfo(URL url) {
            this(url, (URLFileSystem.isDirectory(url) ? 1 : 0) | (URLFileSystem.isRegularFile(url) ? 2 : 0) | (URLFileSystem.isHidden(url) ? 4 : 0), URLFileSystem.lastModified(url), URLFileSystem.getLength(url));
        }

        protected FileInfo(File parent, String name, int attributes, long lastModified, long length) {
            this(new File(parent, name), attributes, lastModified, length);
        }

        protected FileInfo(String parent, String name, int attributes, long lastModified, long length) {
            this(new File(parent, name), attributes, lastModified, length);
        }

        protected FileInfo(File file, int attributes, long lastModified, long length) {
            this(file.getAbsolutePath(), attributes, lastModified, length);
        }

        protected FileInfo(String path, int attributes, long lastModified, long length) {
            this((attributes & 1) != 0 ? URLFactory.newDirURL(path) : URLFactory.newFileURL(path), attributes, lastModified, length);
        }

        protected FileInfo(URL url, int attributes, long lastModified, long length) {
            this.url = url;
            this.attributes = attributes;
            this.lastModified = lastModified;
            this.length = length;
        }

        public URL getURL() {
            return this.url;
        }

        public boolean isDirectory() {
            return (this.attributes & 1) != 0;
        }

        public boolean isFile() {
            return (this.attributes & 2) != 0;
        }

        public boolean isHidden() {
            return (this.attributes & 4) != 0;
        }

        public long lastModified() {
            return this.lastModified;
        }

        public long length() {
            return this.length;
        }
    }

    static final class 2
    implements URLFileSystemListener {
        private final /* synthetic */ URL v$rootURL;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyEvent(URLFileSystemEvent event) {
            CopyOnWriteArrayList listenerList;
            HashMap hashMap = URLFileSystem.ra$_rootURLToListenerMap();
            synchronized (hashMap) {
                listenerList = (CopyOnWriteArrayList)URLFileSystem.ra$_rootURLToListenerMap().get(this.v$rootURL);
            }
            for (URLFileSystemListener listener : listenerList) {
                listener.notifyEvent(event);
            }
        }

        public 2(URL uRL) {
            this.v$rootURL = uRL;
        }
    }

    static final class 3
    implements Runnable {
        public void run() {
            URLFileSystem.wa$TRACE_DANGLING_STREAMS(true);
        }
    }

    protected static class TrackedOutputStream
    extends OutputStream {
        private OutputStream _tracked;
        private Runnable _runnable;
        private boolean _closed;
        private Exception _trace;

        private void $init$() {
            this._closed = false;
            this._trace = null;
        }

        protected TrackedOutputStream(Runnable runnable, OutputStream tracked) {
            this.$init$();
            this._runnable = runnable;
            this._tracked = tracked;
            if (URLFileSystem.ra$TRACE_DANGLING_STREAMS()) {
                this._trace = new RuntimeException("OutputStream allocation point");
            }
        }

        public void write(int b) throws IOException {
            this._tracked.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this._tracked.write(b, off, len);
        }

        public void flush() throws IOException {
            this._tracked.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            TrackedOutputStream trackedOutputStream = this;
            synchronized (trackedOutputStream) {
                if (!this._closed) {
                    this._closed = true;
                    try {
                        if (this._tracked != null) {
                            this._tracked.close();
                            this._tracked = null;
                        }
                        this._trace = null;
                    }
                    finally {
                        if (this._runnable != null) {
                            this._runnable.run();
                            this._runnable = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TrackedOutputStream trackedOutputStream = this;
            synchronized (trackedOutputStream) {
                if (this._closed || this._trace != null) {
                    // empty if block
                }
            }
            Thread currentThread = Thread.currentThread();
            ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
            try {
                currentThread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                this.close();
            }
            finally {
                currentThread.setContextClassLoader(oldContextClassLoader);
            }
        }
    }
}

