/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Manifest;
import oracle.ide.net.JarIndex;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTempFile;
import oracle.ide.util.TimedCache;

public final class JarUtil {
    private static final boolean CACHE_ENABLED = Boolean.getBoolean("ide.jar.nocache") ^ true;
    static final String JAR_URL_SEPARATOR = "!/";
    private static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    private static final TimedCache _cachedJarIndexes = new TimedCache(300);
    private static final Object JAR_INDEX_LOCK = new Object();
    private static final TimedCache _urlTempFileCache = new TimedCache(300);

    private JarUtil() {
    }

    public static String getJarEntry(URL jarURL) {
        String urlPathStr;
        int bangPos;
        if (JarUtil.isJarURL(jarURL) && (bangPos = (urlPathStr = jarURL.getPath()).indexOf(JAR_URL_SEPARATOR)) >= 0) {
            return urlPathStr.substring(bangPos + 2);
        }
        return null;
    }

    public static URL getJarFileURL(URL jarURL) {
        if (JarUtil.isJarURL(jarURL)) {
            try {
                String urlPathStr = jarURL.getPath();
                int bangSlashPos = urlPathStr.indexOf(JAR_URL_SEPARATOR);
                if (bangSlashPos >= 0) {
                    String resultStr = urlPathStr.substring(0, bangSlashPos);
                    URL uRL = JarUtil.newJarFileURLImplImpl(resultStr);
                    return uRL;
                }
                if (urlPathStr.endsWith("!")) {
                    String resultStr = urlPathStr.substring(0, urlPathStr.length() - 1);
                    URL uRL = JarUtil.newJarFileURLImplImpl(resultStr);
                    return uRL;
                }
                URL uRL = JarUtil.newJarFileURLImplImpl(urlPathStr);
                return uRL;
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Invalid JAR URL: " + jarURL, e);
            }
        }
        return jarURL;
    }

    public static Manifest getManifest(URL jarURL) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static Manifest getManifest(File jarFile) throws IOException {
        return JarUtil.getManifestImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(File jarFile) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getMainClass(URL jarURL) throws IOException {
        return JarUtil.getMainClassImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static String getClassPath(File jarFile) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarFile));
    }

    public static String getClassPath(URL jarURL) throws IOException {
        return JarUtil.getClassPathImpl(JarUtil.getManifestFileURL(jarURL));
    }

    public static boolean isJarURL(URL jarURL) {
        return jarURL != null ? jarURL.getProtocol().equals("jar") : false;
    }

    public static JarIndex getJarIndex(URL jarURL) throws IOException {
        return JarUtil.getJarIndex(jarURL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JarIndex getJarIndex(URL jarURL, boolean full) throws IOException {
        if (jarURL == null) {
            return null;
        }
        URL jarFileURL = JarUtil.getJarFileURL(jarURL);
        long jarTimestamp = URLFileSystem.lastModified(jarFileURL);
        if (!CACHE_ENABLED) {
            JarIndex index = new JarIndex(jarFileURL, jarTimestamp);
            index.buildIndex(full);
            return index;
        }
        while (true) {
            Object buildLock = null;
            boolean buildIndex = false;
            Object object = JAR_INDEX_LOCK;
            synchronized (object) {
                Object index = _cachedJarIndexes.get(jarFileURL);
                if (index != null && index instanceof JarIndex) {
                    JarIndex cachedIndex = (JarIndex)index;
                    if (jarTimestamp == (long)-1 && cachedIndex.getTimestamp() == jarTimestamp || jarTimestamp != (long)-1 && cachedIndex.getTimestamp() >= jarTimestamp) {
                        JarIndex jarIndex = cachedIndex;
                        return jarIndex;
                    }
                    _cachedJarIndexes.put(jarFileURL, null);
                    index = null;
                }
                if (index == null) {
                    buildIndex = true;
                    buildLock = new Object();
                    _cachedJarIndexes.put(jarFileURL, buildLock);
                } else {
                    buildLock = index;
                }
            }
            Object object2 = buildLock;
            synchronized (object2) {
                if (!buildIndex) {
                    try {
                        buildLock.wait(50);
                    }
                    catch (InterruptedException e) {}
                } else {
                    JarIndex builtIndex = null;
                    try {
                        try {
                            builtIndex = new JarIndex(jarFileURL, jarTimestamp);
                            builtIndex.buildIndex(full);
                        }
                        catch (IOException e) {
                            builtIndex = null;
                            throw e;
                        }
                        catch (RuntimeException e) {
                            builtIndex = null;
                            throw e;
                        }
                    }
                    catch (Throwable throwable) {
                        Object object3 = JAR_INDEX_LOCK;
                        synchronized (object3) {
                            _cachedJarIndexes.put(jarFileURL, builtIndex);
                        }
                        buildLock.notifyAll();
                        throw throwable;
                    }
                    Object object4 = JAR_INDEX_LOCK;
                    synchronized (object4) {
                        _cachedJarIndexes.put(jarFileURL, builtIndex);
                    }
                    buildLock.notifyAll();
                    JarIndex jarIndex = builtIndex;
                    return jarIndex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseJarIndex(URL jarURL) {
        URL jarFileURL = JarUtil.getJarFileURL(jarURL);
        if (jarFileURL != null) {
            Object object = JAR_INDEX_LOCK;
            synchronized (object) {
                _cachedJarIndexes.put(jarFileURL, null);
            }
        }
    }

    public static boolean isArchive(String pathname) {
        int lastDot = pathname.lastIndexOf(46);
        if (lastDot < 0) {
            return false;
        }
        String ext = pathname.substring(lastDot).toLowerCase();
        return ext.equals(".jar") || ext.equals(".zip");
    }

    private static URL getManifestFileURL(File jarFile) {
        return URLFactory.newJarURL(jarFile, MANIFEST_FILE);
    }

    private static URL getManifestFileURL(URL jarURL) {
        return URLFactory.newJarURL(jarURL, MANIFEST_FILE);
    }

    private static String getMainClassImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, "Main-Class");
    }

    private static String getClassPathImpl(URL manifestFileURL) throws IOException {
        return JarUtil.getManifestMainAttribute(manifestFileURL, "Class-Path");
    }

    private static Manifest getManifestImpl(URL manifestFileURL) throws IOException {
        InputStream manifestIn = null;
        try {
            manifestIn = URLFileSystem.openInputStream(manifestFileURL);
            Manifest manifest = new Manifest(manifestIn);
            return manifest;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (manifestIn != null) {
                try {
                    manifestIn.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static String getManifestMainAttribute(URL manifestFileURL, String mainAttrName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File getLocalTempJarFile(URL jarFileURL) {
        URLTempFile urlTempFile;
        TimedCache timedCache = _urlTempFileCache;
        synchronized (timedCache) {
            Object tempFileObj = _urlTempFileCache.get(jarFileURL);
            if (tempFileObj != null) {
                urlTempFile = (URLTempFile)tempFileObj;
            } else {
                urlTempFile = new URLTempFile(jarFileURL);
                _urlTempFileCache.put(jarFileURL, urlTempFile);
            }
        }
        return urlTempFile.getFile();
    }

    static URL newJarFileURLImpl(String urlStr) {
        try {
            URL uRL = JarUtil.newJarFileURLImplImpl(urlStr);
            return uRL;
        }
        catch (MalformedURLException e) {
            URL uRL = null;
            return uRL;
        }
    }

    private static URL newJarFileURLImplImpl(String urlStr) throws MalformedURLException {
        return new URL(urlStr);
    }
}

