/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.util.Date;
import java.util.GregorianCalendar;

public class JarIndexEntry {
    private final String _name;
    private final int _compressedSize;
    private final int _size;
    private final Date _time;

    JarIndexEntry(String name, int compressedSize, int size, int dostime) {
        this._name = name;
        this._compressedSize = compressedSize;
        this._size = size;
        this._time = JarIndexEntry.dostime2Date(dostime);
    }

    public String getName() {
        return this._name;
    }

    public int getSize() {
        return this._size;
    }

    public int getCompressedSize() {
        return this._compressedSize;
    }

    public Date getTime() {
        return this._time;
    }

    private static Date dostime2Date(int dostime) {
        GregorianCalendar cal = new GregorianCalendar((dostime >> 25 & 0x7F) + 80, (dostime >> 21 & 0xF) - 1, dostime >> 16 & 0x1F, dostime >> 11 & 0x1F, dostime >> 5 & 0x3F, dostime << 1 & 0x3E);
        return cal.getTime();
    }
}

