/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.zip.Inflater;
import javax.swing.Timer;
import oracle.ide.net.AlikeStrings;
import oracle.ide.net.InflaterInputStream;
import oracle.ide.net.JarIndexEntry;
import oracle.ide.net.JarUtil;
import oracle.ide.util.ModelUtil;

public final class JarIndex {
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    private static final String JAR_CHARSETNAME = "UTF8";
    private final URL _jarFileURL;
    private final long _timestamp;
    private int[] _offsets;
    private int[] _cSizes;
    private int[] _ucSizes;
    private int[] _dostimes;
    private int[] _table;
    private int[] _tableData;
    private int _tableLen;
    private int numEntries;
    private long centralDirOffset;
    private int centralDirSize;
    private boolean pathlessFiles;
    private AlikeStrings _entryNamesPool;
    private final Object _buildLock;

    private void $init$() {
        this._buildLock = new Object();
    }

    JarIndex(URL jarFileURL, long timestamp) {
        this.$init$();
        this._jarFileURL = jarFileURL;
        this._timestamp = timestamp;
    }

    public int dirEntryIndex(String entryName) {
        return this.dirEntryIndexImpl(entryName.endsWith("/") ? entryName : entryName + "/");
    }

    public int entryIndex(String entryName) {
        if (entryName.endsWith("/")) {
            return this.dirEntryIndexImpl(entryName);
        }
        this.tryBuildFullIndex();
        return this._entryNamesPool.binarySearch(entryName);
    }

    public int getNumEntries() {
        if (this._offsets == null) {
            this.tryBuildFullIndex();
        }
        return this._offsets.length;
    }

    public JarIndexEntry getEntryAt(int i) {
        this.tryBuildFullIndex();
        return new JarIndexEntry(this._entryNamesPool.getStringFromIndex(i), this._cSizes[i], this._ucSizes[i], this._dostimes[i]);
    }

    public String getEntryNameAt(int i) {
        this.tryBuildFullIndex();
        return this._entryNamesPool.getStringFromIndex(i);
    }

    public String[] getEntries() {
        this.tryBuildFullIndex();
        int numEntries = this.getNumEntries();
        String[] entryArray = new String[numEntries];
        int i = 0;
        while (i < numEntries) {
            entryArray[i] = this._entryNamesPool.getStringFromIndex(i);
            ++i;
        }
        return entryArray;
    }

    public int getSize(String entryName) {
        int entryIndex;
        this.tryBuildFullIndex();
        if (entryName != null && (entryIndex = this._entryNamesPool.binarySearch(entryName)) >= 0) {
            return this._ucSizes[entryIndex];
        }
        return -1;
    }

    public String[] list(String dirEntryName) {
        String[] res;
        this.tryBuildFullIndex();
        if (dirEntryName.length() > 0 && ((res = this.listImpl(dirEntryName.endsWith("/") ? dirEntryName : dirEntryName + "/")) != null && res.length > 0 || !this.pathlessFiles || !dirEntryName.equals("./"))) {
            return res;
        }
        return this.listImpl("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openInputStream(String entryName) throws IOException {
        if (entryName != null) {
            byte[] localHeader = new byte[30];
            RandomAccessFile jar = null;
            try {
                RandomAccessFile randomAccessFile = jar = OpenFileCaching.getCachedFile(this._jarFileURL);
                synchronized (randomAccessFile) {
                    int[] offsetAndSizes = this.getLOC(jar, localHeader, entryName);
                    if (offsetAndSizes != null) {
                        int dataLength = offsetAndSizes[1];
                        byte[] dataBytes = new byte[dataLength];
                        jar.readFully(dataBytes);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(dataBytes);
                        int compressionMethod = JarIndex.getCompressionMethod(localHeader);
                        switch (compressionMethod) {
                            case 0: {
                                ByteArrayInputStream byteArrayInputStream = inputStream;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 4, 13, 14] lbl18 : MonitorExitStatement: MONITOREXIT : var9_4
                                if (jar != null) {
                                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                                }
                                return byteArrayInputStream;
                            }
                            case 8: {
                                InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream, new Inflater(true));
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 5, 13, 14] lbl24 : MonitorExitStatement: MONITOREXIT : var9_4
                                if (jar != null) {
                                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                                }
                                return inflaterInputStream;
                            }
                        }
                        throw new IOException("Unsupported compression method (" + compressionMethod + ")");
                    }
                }
            }
            finally {
                if (jar != null) {
                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                }
            }
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String entryName) {
        if (this._entryNamesPool != null) {
            return this.entryIndex(entryName) >= 0;
        }
        boolean exists = false;
        RandomAccessFile file = null;
        try {
            try {
                RandomAccessFile randomAccessFile = file = OpenFileCaching.getCachedFile(this._jarFileURL);
                synchronized (randomAccessFile) {
                    exists = this.getLOC(file, new byte[30], entryName) != null;
                }
            }
            catch (IOException ioe) {}
        }
        finally {
            if (file != null) {
                OpenFileCaching.releaseCachedFile(this._jarFileURL);
            }
        }
        if (!exists && entryName.endsWith("/")) {
            exists = this.dirEntryIndexImpl(entryName) >= 0;
        }
        return exists;
    }

    public static void flushCache() {
        OpenFileCaching.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String entryName) throws IOException {
        this.tryBuildFullIndex();
        if (entryName != null) {
            byte[] localHeader = new byte[30];
            RandomAccessFile jar = null;
            try {
                RandomAccessFile randomAccessFile = jar = OpenFileCaching.getCachedFile(this._jarFileURL);
                synchronized (randomAccessFile) {
                    int[] offsetAndSizes = this.getLOC(jar, localHeader, entryName);
                    if (offsetAndSizes != null) {
                        int dataLength = offsetAndSizes[1];
                        byte[] dataBytes = new byte[dataLength];
                        jar.readFully(dataBytes);
                        int compressionMethod = JarIndex.getCompressionMethod(localHeader);
                        switch (compressionMethod) {
                            case 0: {
                                byte[] byArray = dataBytes;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 4, 14, 15] lbl18 : MonitorExitStatement: MONITOREXIT : var13_4
                                if (jar != null) {
                                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                                }
                                return byArray;
                            }
                            case 8: {
                                ByteArrayInputStream in = new ByteArrayInputStream(dataBytes);
                                int ucDataLength = offsetAndSizes[2];
                                byte[] ucDataBytes = new byte[ucDataLength];
                                InflaterInputStream inflater = new InflaterInputStream(in, new Inflater(true), dataLength);
                                int bytesRead = inflater.read(ucDataBytes, 0, ucDataLength);
                                if (bytesRead == ucDataLength) {
                                    byte[] byArray = ucDataBytes;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3, 5, 12, 14, 15] lbl30 : MonitorExitStatement: MONITOREXIT : var13_4
                                    if (jar != null) {
                                        OpenFileCaching.releaseCachedFile(this._jarFileURL);
                                    }
                                    return byArray;
                                }
                                throw new IOException("Unexpected EOF -- corrupted jar file");
                            }
                        }
                        throw new IOException("Unsupported compression method (" + compressionMethod + ")");
                    }
                }
            }
            finally {
                if (jar != null) {
                    OpenFileCaching.releaseCachedFile(this._jarFileURL);
                }
            }
        }
        return new byte[0];
    }

    String canonicalize(String entryName) {
        if (entryName.endsWith("/")) {
            return entryName;
        }
        return entryName;
    }

    void buildIndex() throws IOException {
        this.buildIndex(true);
    }

    void buildIndex(boolean full) throws IOException {
        if (full) {
            this.buildFullIndex();
        } else {
            this.buildHashIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFullIndex() throws IOException {
        if (this._entryNamesPool == null) {
            Object object = this._buildLock;
            synchronized (object) {
                if (this._entryNamesPool == null) {
                    this.buildFullIndexImpl();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void buildFullIndexImpl() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.EclipseLoops.eclipseLoopPass(EclipseLoops.java:51)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.eclipseLoopPass(Op03Rewriters.java:121)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:676)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildHashIndex() throws IOException {
        File jarFile = JarUtil.getLocalTempJarFile(this._jarFileURL);
        if (jarFile == null) return;
        if (!jarFile.exists()) {
            return;
        }
        RandomAccessFile jar = null;
        try {
            jar = new RandomAccessFile(jarFile, "r");
            if (this.centralDirSize == 0 && !this.findCDIR(jar)) {
                return;
            }
            byte[] cdir = new byte[this.centralDirSize];
            jar.seek(this.centralDirOffset);
            jar.readFully(cdir);
            this._tableLen = this.numEntries / 2 + 1;
            this._table = new int[this._tableLen];
            this._tableData = new int[this.numEntries * 3 + 1];
            int numLoops = 0;
            int j = 0;
            while (j < this.centralDirSize) {
                if (numLoops >= this.numEntries) {
                    return;
                }
                int compressedSize = JarIndex.get4LE(cdir, j + 20);
                int filenameLen = JarIndex.get2LE(cdir, j + 28);
                int extraFieldLen = JarIndex.get2LE(cdir, j + 30);
                int commentLen = JarIndex.get2LE(cdir, j + 32);
                int offset = JarIndex.get4LE(cdir, j + 42);
                int entryNameOffset = j + 46;
                int hash = JarIndex.hash(cdir, j + 46, filenameLen) % this._tableLen;
                int k = numLoops * 3 + 1;
                this._tableData[k] = offset;
                this._tableData[k + 1] = compressedSize;
                this._tableData[k + 2] = this._table[hash];
                this._table[hash] = k;
                j = entryNameOffset + filenameLen + extraFieldLen + commentLen;
                ++numLoops;
            }
            return;
        }
        finally {
            try {
                if (jar == null) return;
                jar.close();
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void tryBuildFullIndex() {
        try {
            this.buildFullIndex();
        }
        catch (IOException ioe) {
            this.initArrays(0);
            this._entryNamesPool = new AlikeStrings(new String[0]);
        }
    }

    private void initArrays(int size) {
        this._offsets = new int[size];
        this._cSizes = new int[size];
        this._ucSizes = new int[size];
        this._dostimes = new int[size];
    }

    private void sortArrays(String[] _entryNames, int lo, int hi) {
        int i = lo;
        int j = hi;
        String pivot = _entryNames[(i + j) / 2];
        while (true) {
            if (_entryNames[i].compareTo(pivot) < 0) {
                ++i;
                continue;
            }
            while (pivot.compareTo(_entryNames[j]) < 0) {
                --j;
            }
            if (i <= j) {
                String temp1 = _entryNames[i];
                _entryNames[i] = _entryNames[j];
                _entryNames[j] = temp1;
                int temp2 = this._offsets[i];
                this._offsets[i] = this._offsets[j];
                this._offsets[j] = temp2;
                temp2 = this._cSizes[i];
                this._cSizes[i] = this._cSizes[j];
                this._cSizes[j] = temp2;
                temp2 = this._ucSizes[i];
                this._ucSizes[i] = this._ucSizes[j];
                this._ucSizes[j] = temp2;
                temp2 = this._dostimes[i];
                this._dostimes[i] = this._dostimes[j];
                this._dostimes[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            this.sortArrays(_entryNames, lo, j);
        }
        if (i < hi) {
            this.sortArrays(_entryNames, i, hi);
        }
    }

    private int[] getOffsetAndSizes(String jarEntryName) {
        int entryIndex;
        if (jarEntryName != null && (entryIndex = this._entryNamesPool.binarySearch(jarEntryName)) >= 0) {
            return new int[]{this._offsets[entryIndex], this._cSizes[entryIndex], this._ucSizes[entryIndex]};
        }
        return new int[]{-1, -1, -1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getLOC(RandomAccessFile jar, byte[] localHeader, String entryName) throws IOException {
        int[] offsetAndSizes;
        int offset;
        if (this._entryNamesPool == null) {
            Object object = this._buildLock;
            synchronized (object) {
                if (this._entryNamesPool == null) {
                    int[] nArray = this.getLOCFromHash(jar, localHeader, entryName);
                    return nArray;
                }
            }
        }
        if ((offset = (offsetAndSizes = this.getOffsetAndSizes(entryName))[0]) >= 0) {
            jar.seek(offset);
            jar.read(localHeader, 0, 30);
            if (localHeader[0] == 80 && localHeader[1] == 75 && localHeader[2] == 3 && localHeader[3] == 4) {
                int filenameLength = (localHeader[26] & 0xFF) + ((localHeader[27] & 0xFF) << 8);
                byte[] filenameBytes = new byte[filenameLength];
                jar.readFully(filenameBytes);
                String filename = new String(filenameBytes, JAR_CHARSETNAME);
                if (ModelUtil.areDifferent(filename, entryName)) {
                    throw new IOException("Mismatched entry names '" + filename + "' and '" + entryName + "' for jar file" + this._jarFileURL.toString());
                }
                int extraFieldLength = (localHeader[28] & 0xFF) + ((localHeader[29] & 0xFF) << 8);
                jar.skipBytes(extraFieldLength);
                return offsetAndSizes;
            }
            throw new IOException("Corrupt entry offset for URL " + this._jarFileURL.toString());
        }
        throw new FileNotFoundException(this.getJarEntryString(entryName));
    }

    private int[] getLOCFromHash(RandomAccessFile jar, byte[] localHeader, String entryName) throws IOException {
        if (this._table == null) {
            return null;
        }
        byte[] b = entryName.getBytes(JAR_CHARSETNAME);
        int hash = JarIndex.hash(b, 0, b.length);
        int i = this._table[hash % this._tableLen];
        while (i != 0) {
            int nlen;
            int offset = this._tableData[i];
            jar.seek(offset);
            jar.read(localHeader, 0, 30);
            if ((long)JarIndex.get4LE(localHeader, 0) == 67324752L && (nlen = JarIndex.get2LE(localHeader, 26)) > 0 && nlen == b.length) {
                byte[] buffer = new byte[nlen];
                jar.seek(offset + 30);
                jar.readFully(buffer);
                boolean match = true;
                int j = 0;
                while (j < nlen) {
                    if (b[j] != buffer[j]) {
                        match = false;
                        break;
                    }
                    ++j;
                }
                if (match) {
                    int extraFieldLength = (localHeader[28] & 0xFF) + ((localHeader[29] & 0xFF) << 8);
                    jar.skipBytes(extraFieldLength);
                    return new int[]{this._tableData[i], this._tableData[i + 1], 0};
                }
            }
            i = this._tableData[i + 2];
        }
        return null;
    }

    private String getJarEntryString(String entryName) {
        return this._jarFileURL.toString() + "!/" + entryName;
    }

    private static int getCompressionMethod(byte[] localHeader) {
        return (localHeader[8] & 0xFF) + ((localHeader[9] & 0xFF) << 8);
    }

    public long getTimestamp(int index) {
        if (index < 0 || this._dostimes == null || index >= this._dostimes.length) {
            return this.getTimestamp();
        }
        int dtime = this._dostimes[index];
        GregorianCalendar gc = new GregorianCalendar((dtime >> 25 & 0x7F) + 80 + 1900, (dtime >> 21 & 0xF) - 1, dtime >> 16 & 0x1F, dtime >> 11 & 0x1F, dtime >> 5 & 0x3F, dtime << 1 & 0x3E);
        return gc.getTimeInMillis();
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    private static int get2LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8);
    }

    private static int get4LE(byte[] b, int i) {
        return (b[i] & 0xFF) + ((b[i + 1] & 0xFF) << 8) + ((b[i + 2] & 0xFF) << 16) + (b[i + 3] << 24);
    }

    private int dirEntryIndexImpl(String entryName) {
        String nextEntry;
        this.tryBuildFullIndex();
        int index = this._entryNamesPool.binarySearch(entryName);
        if (index >= 0) {
            return index;
        }
        if (this.pathlessFiles && entryName.equals("./")) {
            return 0;
        }
        int insertPoint = -index - 1;
        if (insertPoint < this._offsets.length && (nextEntry = this._entryNamesPool.getStringFromIndex(insertPoint)).startsWith(entryName)) {
            return insertPoint;
        }
        return -1;
    }

    private String[] listImpl(String dirEntryName) {
        ArrayList<String> list = new ArrayList<String>();
        int n = this._offsets.length;
        int dirLen = dirEntryName.length();
        int i = this._entryNamesPool.binarySearch(dirEntryName);
        if (i >= 0) {
            ++i;
        } else if (dirLen > 0) {
            if ((i = -i - 1) >= this._offsets.length) {
                return new String[0];
            }
        } else {
            i = 0;
        }
        while (i < n) {
            String entryName = this._entryNamesPool.getStringFromIndex(i);
            if (!entryName.startsWith(dirEntryName)) break;
            if (entryName.length() != dirLen) {
                String listEntry;
                int endEntry = entryName.indexOf(47, dirLen);
                String string = listEntry = endEntry >= dirLen ? entryName.substring(dirLen, endEntry + 1) : entryName.substring(dirLen);
                if (!list.contains(listEntry)) {
                    list.add(listEntry);
                }
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    private static int hash(byte[] b, int offset, int len) {
        int n = offset + len;
        if (n > b.length) {
            n = b.length;
        }
        int h = 0;
        int i = offset;
        while (i < n) {
            h = 31 * h + b[i];
            ++i;
        }
        return h & Integer.MAX_VALUE;
    }

    private boolean findCDIR(RandomAccessFile jar) throws IOException {
        long length = jar.length();
        long seek = length - (long)22;
        byte[] bytes = new byte[22];
        int remainingZipCommentLength = 65535;
        boolean centralDirectoryFound = false;
        while (seek >= 0L && remainingZipCommentLength > 0) {
            jar.seek(seek);
            jar.readFully(bytes);
            if (bytes[0] == 80 && bytes[1] == 75 && bytes[2] == 5 && bytes[3] == 6) {
                this.numEntries = JarIndex.get2LE(bytes, 10);
                this.centralDirSize = JarIndex.get4LE(bytes, 12);
                this.centralDirOffset = JarIndex.get4LE(bytes, 16);
                int actualCommentLength = 65535 - remainingZipCommentLength;
                if (actualCommentLength > 0) {
                    int commentLength = JarIndex.get2LE(bytes, 20);
                    if (commentLength != actualCommentLength) break;
                    centralDirectoryFound = true;
                    break;
                }
                centralDirectoryFound = true;
                break;
            }
            --seek;
            --remainingZipCommentLength;
        }
        if (!centralDirectoryFound || this.centralDirSize <= 0 || (long)this.centralDirSize >= length) {
            // empty if block
        }
        return centralDirectoryFound;
    }

    static class OpenFileCaching
    implements ActionListener {
        private static HashMap _openJars;
        private static Timer _cacheTimer;
        private static final int CACHE_DELAY = 5000;
        private static OpenFileCaching _instance;
        private static final boolean DO_NOT_CACHE;

        public static synchronized void checkInit() {
            if (_instance != null) {
                return;
            }
            _openJars = new HashMap();
            _instance = new OpenFileCaching();
            _cacheTimer = new Timer(5000, _instance);
        }

        public void actionPerformed(ActionEvent ev) {
            OpenFileCaching.flushCache();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void flushCache() {
            if (_openJars == null) {
                return;
            }
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                URL[] key = _openJars.keySet().toArray(new URL[_openJars.size()]);
                int i = 0;
                while (i < key.length) {
                    URL url = key[i];
                    Entry e = (Entry)_openJars.get(url);
                    if (e.isUnused()) {
                        RandomAccessFile f = e.file;
                        try {
                            f.close();
                        }
                        catch (Throwable ex) {
                            // empty catch block
                        }
                        _openJars.remove(url);
                    }
                    ++i;
                }
                if (_openJars.isEmpty()) {
                    _cacheTimer.stop();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static RandomAccessFile getCachedFile(URL url) throws FileNotFoundException {
            Entry e;
            OpenFileCaching.checkInit();
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                _cacheTimer.restart();
                e = (Entry)_openJars.get(url);
                if (e == null) {
                    File jarFile = JarUtil.getLocalTempJarFile(url);
                    RandomAccessFile jar = new RandomAccessFile(jarFile, "r");
                    e = new Entry(jar);
                    _openJars.put(url, e);
                }
                ++e.useCount;
            }
            return e.file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void releaseCachedFile(URL url) {
            HashMap hashMap = _openJars;
            synchronized (hashMap) {
                _cacheTimer.restart();
                Entry e = (Entry)_openJars.get(url);
                if (e != null) {
                    --e.useCount;
                }
                if (DO_NOT_CACHE) {
                    OpenFileCaching.flushCache();
                }
            }
        }

        OpenFileCaching() {
        }

        static {
            DO_NOT_CACHE = Boolean.getBoolean("ide.jarcache.disabled");
        }

        static class Entry {
            public RandomAccessFile file;
            public int useCount;

            public Entry(RandomAccessFile f) {
                this.file = f;
            }

            public boolean isUnused() {
                return this.useCount == 0;
            }
        }
    }
}

