/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;

public class HttpURLFileSystemHelper
extends URLFileSystemHelper {
    private HashMap _unreachableMap;
    private String _proxyHost;
    private String _proxyPort;
    private static final int DEFAULT_PORT = 80;

    private void $init$() {
        this._unreachableMap = new HashMap();
    }

    public String getSystemDisplayName(URL url) {
        if (URLFileSystem.isRoot(url)) {
            return URLFileSystem.getPlatformPathName(url);
        }
        return URLFileSystem.getFileName(url);
    }

    public long getLength(URL url) {
        this._checkProxy();
        if (this._unreachableMap.containsKey(url.getHost())) {
            return -1;
        }
        try {
            URLConnection urlConnection = url.openConnection();
            long l = urlConnection.getContentLength();
            try {
                return l;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        catch (NoRouteToHostException nrex) {
            this._unreachableMap.put(url.getHost(), null);
            long l = -1;
            return l;
        }
        catch (Exception e) {
            long l = -1;
            return l;
        }
    }

    public long lastModified(URL url) {
        this._checkProxy();
        if (this._unreachableMap.containsKey(url.getHost())) {
            return -1;
        }
        try {
            URLConnection urlConnection = url.openConnection();
            long l = urlConnection.getLastModified();
            try {
                return l;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    urlConnection.getInputStream().close();
                }
                catch (Exception exception) {}
            }
        }
        catch (NoRouteToHostException nrex) {
            this._unreachableMap.put(url.getHost(), null);
            long l = -1;
            return l;
        }
        catch (Exception e) {
            long l = -1;
            return l;
        }
    }

    public boolean exists(URL url) {
        boolean result;
        block14: {
            result = false;
            this._checkProxy();
            String host = url.getHost();
            if (!this._unreachableMap.containsKey(host)) {
                InputStream in = null;
                try {
                    try {
                        String resolvedFile;
                        URLConnection connection = url.openConnection();
                        if (!(connection instanceof HttpURLConnection)) break block14;
                        HttpURLConnection httpCon = (HttpURLConnection)connection;
                        in = httpCon.getInputStream();
                        int code = httpCon.getResponseCode();
                        result = code >= 100 & code < 400;
                        if (code != 200) break block14;
                        String requestedFile = URLFileSystem.getFileName(url);
                        if (requestedFile.equals(resolvedFile = URLFileSystem.getFileName(httpCon.getURL()))) {
                            result = true;
                            break block14;
                        }
                        result = false;
                    }
                    catch (NoRouteToHostException nrex) {
                        this._unreachableMap.put(host, null);
                    }
                    catch (ConnectException ce) {
                    }
                    catch (IOException ex) {}
                }
                finally {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception ex) {}
                }
            }
        }
        return result;
    }

    public boolean canCreate(URL url) {
        boolean result = false;
        this._checkProxy();
        String host = url.getHost();
        if (!this._unreachableMap.containsKey(host)) {
            while (url != null) {
                if (this.exists(url)) {
                    result = this.canWrite(url);
                    break;
                }
                url = this.getParent(url);
            }
        }
        return result;
    }

    public URL getParent(URL url) {
        URL parent = super.getParent(url);
        if (parent != null && parent.equals(url)) {
            parent = null;
        }
        return parent;
    }

    public InputStream openInputStream(URL url) throws IOException {
        this._checkProxy();
        String host = url.getHost();
        try {
            if (!this._unreachableMap.containsKey(host)) {
                URLConnection connection = url.openConnection();
                InputStream inputStream = connection.getInputStream();
                return inputStream;
            }
        }
        catch (NoRouteToHostException ex) {
            this._unreachableMap.put(host, null);
            throw ex;
        }
        throw new IOException();
    }

    private void _checkProxy() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (this._areDifferent(this._proxyHost, proxyHost) || this._areDifferent(this._proxyPort, proxyPort)) {
            this._unreachableMap.clear();
            this._proxyHost = proxyHost;
            this._proxyPort = proxyPort;
        }
    }

    private boolean _areDifferent(String s1, String s2) {
        return s1 == null ? s2 != null : s1.equals(s2) ^ true;
    }

    protected boolean haveSamePort(URL url1, URL url2) {
        int p1 = url1.getPort() != -1 ? url1.getPort() : 80;
        int p2 = url2.getPort() != -1 ? url2.getPort() : 80;
        return p1 == p2;
    }

    public HttpURLFileSystemHelper() {
        this.$init$();
    }
}

