/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import oracle.ide.net.NameGenerator;

public class DefaultNameGenerator
implements NameGenerator {
    private final String _name;
    private final String _suffix;
    private int _index;

    public DefaultNameGenerator(String name, String suffix) {
        this(name, suffix, 1);
    }

    public DefaultNameGenerator(String name, String suffix, int initialIndex) {
        if (name == null || name.length() <= 0) {
            throw new IllegalArgumentException();
        }
        this._name = name;
        this._suffix = suffix == null || suffix.length() == 0 ? "" : (suffix.startsWith(".") ? suffix : "." + suffix);
        this._index = initialIndex;
    }

    public String nextName() {
        StringBuffer name = new StringBuffer();
        name.append(this.getName());
        int index = this.nextIndex();
        if (index >= 0) {
            name.append(index);
        }
        name.append(this.getSuffix());
        return name.toString();
    }

    protected String getName() {
        return this._name;
    }

    protected String getSuffix() {
        return this._suffix;
    }

    protected int nextIndex() {
        if (this._index < 0) {
            this._index = 1;
            return -1;
        }
        return this._index++;
    }
}

