/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilenameFilter;
import oracle.ide.net.URLFilter;

final class CodeSourceURLFileSystemHelper
extends URLFileSystemHelper {
    public boolean canCreate(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.canCreate(convertedURL);
        }
        return super.canCreate(url);
    }

    public boolean canDelete(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.canDelete(convertedURL);
        }
        return super.canDelete(url);
    }

    public boolean canRead(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.canRead(convertedURL);
        }
        return super.canRead(url);
    }

    public boolean canWrite(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.canWrite(convertedURL);
        }
        return super.canWrite(url);
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.createReader(convertedURL, encoding);
        }
        return super.createReader(url, encoding);
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(directory);
        if (convertedURL != directory) {
            return URLFileSystem.createTempFile(prefix, suffix, convertedURL);
        }
        return super.createTempFile(prefix, suffix, directory);
    }

    public void delete(URL url) throws IOException {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            URLFileSystem.delete(convertedURL);
        } else {
            super.delete(url);
        }
    }

    public boolean exists(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.exists(convertedURL);
        }
        return super.exists(url);
    }

    public long lastModified(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.lastModified(convertedURL);
        }
        return super.lastModified(url);
    }

    public URL[] list(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.list(convertedURL);
        }
        return super.list(url);
    }

    public URL[] list(URL url, URLFilenameFilter filter) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.list(convertedURL, filter);
        }
        return super.list(url, filter);
    }

    public URL[] list(URL url, URLFilter filter) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.list(convertedURL, filter);
        }
        return super.list(url, filter);
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.ls(convertedURL);
        }
        return super.ls(url);
    }

    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.ls(convertedURL, filter);
        }
        return super.ls(url, filter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.lsCached(convertedURL);
        }
        return super.lsCached(url);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.lsCached(convertedURL, filter);
        }
        return super.lsCached(url, filter);
    }

    public boolean mkdir(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.mkdir(convertedURL);
        }
        return super.mkdir(url);
    }

    public boolean mkdirs(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.mkdirs(convertedURL);
        }
        return super.mkdirs(url);
    }

    public InputStream openInputStream(URL url) throws IOException {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.openInputStream(convertedURL);
        }
        return super.openInputStream(url);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.openOutputStream(convertedURL);
        }
        return super.openOutputStream(url);
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        URL convertedOldURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(oldURL);
        URL convertedNewURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(newURL);
        if (convertedOldURL != oldURL && convertedNewURL != newURL) {
            URLFileSystem.renameEx(convertedOldURL, convertedNewURL);
        } else {
            super.rename(oldURL, newURL);
        }
    }

    public boolean setLastModified(URL url, long time) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.setLastModified(convertedURL, time);
        }
        return super.setLastModified(url, time);
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.setReadOnly(convertedURL, readOnly);
        }
        return super.setReadOnly(url, readOnly);
    }

    public long getLength(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.getLength(convertedURL);
        }
        return super.getLength(url);
    }

    public String getPlatformPathName(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.getPlatformPathName(convertedURL);
        }
        return super.getPlatformPathName(url);
    }

    public boolean isReadOnly(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.isReadOnly(convertedURL);
        }
        return super.isReadOnly(url);
    }

    public boolean isRegularFile(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.isRegularFile(convertedURL);
        }
        return super.isRegularFile(url);
    }

    public boolean isValid(URL url) {
        URL convertedURL = CodeSourceURLFileSystemHelper.convertToFileOrJarURL(url);
        if (convertedURL != url) {
            return URLFileSystem.isValid(convertedURL);
        }
        return super.isValid(url);
    }

    private static URL convertToFileOrJarURL(URL codeSourceURL) {
        if (codeSourceURL != null && "code-source".equalsIgnoreCase(codeSourceURL.getProtocol())) {
            String path = codeSourceURL.getPath();
            if (path.indexOf("!/") > 0) {
                return URLFactory.newURL("jar", codeSourceURL.getUserInfo(), codeSourceURL.getHost(), codeSourceURL.getPort(), "file:" + codeSourceURL.getPath(), codeSourceURL.getQuery(), codeSourceURL.getRef());
            }
            return URLFactory.replaceProtocolPart(codeSourceURL, "file");
        }
        return codeSourceURL;
    }

    CodeSourceURLFileSystemHelper() {
    }
}

