package com.mycompany.jerseyclient;

import java.awt.Cursor;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class MainWindow extends javax.swing.JFrame {

    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
    }

    private void initContent() {
        setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        propertiesList.setModel(new ListModel() {
            String[] properties = DataProvider.getPropertyNames();

            public int getSize() {
                return properties.length;
            }

            public Object getElementAt(int index) {
                return properties[index];
            }

            public void addListDataListener(ListDataListener l) {}
            public void removeListDataListener(ListDataListener l) {}
        });
        setCursor(Cursor.getDefaultCursor());
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        propertiesList = new javax.swing.JList();
        editButton = new javax.swing.JButton();
        deleteButton = new javax.swing.JButton();
        refreshButton = new javax.swing.JButton();
        newButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("System Properties");
        setName("MainWindow"); // NOI18N

        propertiesList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jScrollPane1.setViewportView(propertiesList);

        editButton.setMnemonic('e');
        editButton.setText("Edit");
        editButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editButtonActionPerformed(evt);
            }
        });

        deleteButton.setMnemonic('d');
        deleteButton.setText("Delete");
        deleteButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                deleteButtonActionPerformed(evt);
            }
        });

        refreshButton.setMnemonic('r');
        refreshButton.setText("Refresh");
        refreshButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                refreshButtonActionPerformed(evt);
            }
        });

        newButton.setMnemonic('n');
        newButton.setText("New");
        newButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 250, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(refreshButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(deleteButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(editButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(newButton, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 226, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(newButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(editButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(deleteButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(refreshButton)))
                .addContainerGap())
        );

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        java.awt.Dimension dialogSize = getSize();
        setLocation((screenSize.width-dialogSize.width)/2,(screenSize.height-dialogSize.height)/2);
    }// </editor-fold>//GEN-END:initComponents

    private void deleteButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_deleteButtonActionPerformed
        // user clicked the Delete button
        // find out which property is selected
        String propertyName = (String) propertiesList.getSelectedValue();
        // if there is a selected property, delete it
        if (propertyName != null) {
            // ask for confirmation
            if (JOptionPane.showConfirmDialog(this, "Are you sure?", "Delete \"" + propertyName + "\"", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                // delete the property if confirmed
                DataProvider.deleteProperty(propertyName);
                // refresh the content
                initContent();
            }
        }
}//GEN-LAST:event_deleteButtonActionPerformed

    private void editButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editButtonActionPerformed
        // user clicked the Edit button
        // find out which property is selected
        String propertyName = (String) propertiesList.getSelectedValue();
        // do nothing if no property has been selected
        if (propertyName == null) {
            return;
        }

        // Create a new Edit Property window
        EditPropWindow ep = new EditPropWindow(this, true);
        // Let it populate itsef with data based on the selected object
        ep.initContent(propertyName);
        // Show the window - wait for user actions
        ep.setVisible(true);
        // once the window is closed, check if user clicked OK
        if (ep.getReturnStatus() == EditPropWindow.RET_OK) {
            // if so, we need to update the property
            DataProvider.setPropertyValue(propertyName, ep.getPropertyValue());
            // refresh the content
            initContent();
        }
    }//GEN-LAST:event_editButtonActionPerformed

    private void newButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newButtonActionPerformed
        // user clicked the New button
        // Create a new Edit Property window
        EditPropWindow ep = new EditPropWindow(this, true);
        // Send null as a property name -> the window will allow editing the property name
        ep.initContent(null);
        // Show the window - wait for user actions
        ep.setVisible(true);
        // once the window is closed, check if user clicked OK
        if (ep.getReturnStatus() == EditPropWindow.RET_OK) {
            // if so, we need to create the property
            DataProvider.setPropertyValue(ep.getPropertyName(), ep.getPropertyValue());
            // refresh the content
            initContent();
        }
}//GEN-LAST:event_newButtonActionPerformed

    private void refreshButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_refreshButtonActionPerformed
        // when a user click Refresh, simply initialize the content from the DataProvider again
        initContent();
    }//GEN-LAST:event_refreshButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                MainWindow mw = new MainWindow();
                mw.setVisible(true);
                mw.initContent();
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton deleteButton;
    private javax.swing.JButton editButton;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton newButton;
    private javax.swing.JList propertiesList;
    private javax.swing.JButton refreshButton;
    // End of variables declaration//GEN-END:variables
}
