/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client.filter;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;

public final class HTTPBasicAuthFilter
extends ClientFilter {
    private final String authentication;
    private static final String BASE64_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

    public HTTPBasicAuthFilter(String username, String password) {
        this.authentication = "Basic " + this.encodeCredentialsBasic(username, password);
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        if (!cr.getMetadata().containsKey((Object)"Authorization")) {
            cr.getMetadata().add((Object)"Authorization", (Object)this.authentication);
        }
        return this.getNext().handle(cr);
    }

    private String encodeCredentialsBasic(String username, String password) {
        String encode = username + ":" + password;
        int paddingCount = (3 - encode.length() % 3) % 3;
        encode = encode + "\u0000\u0000".substring(0, paddingCount);
        StringBuilder encoded = new StringBuilder();
        for (int i = 0; i < encode.length(); i += 3) {
            int j = (encode.charAt(i) << 16) + (encode.charAt(i + 1) << 8) + encode.charAt(i + 2);
            encoded.append(BASE64_CHARS.charAt(j >> 18 & 0x3F));
            encoded.append(BASE64_CHARS.charAt(j >> 12 & 0x3F));
            encoded.append(BASE64_CHARS.charAt(j >> 6 & 0x3F));
            encoded.append(BASE64_CHARS.charAt(j & 0x3F));
        }
        return encoded.toString();
    }
}

