/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'styleNames'
 */
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
        
public class OdfStyleNames {
	
	private String  mRet;
	
	/**
	 * Construct OdfStyleNames by the parsing the given OdfStyleName list
	 * 
	 * @param styleNames The String to be parsed into OdfStyleNames
	 */
	public OdfStyleNames ( List<OdfStyleName> styleNames)
	{
        StringBuffer aRet = new StringBuffer();
        Iterator<OdfStyleName> aIter = styleNames.iterator();
        while( aIter.hasNext() )
        {
            if( aRet.length() > 0 )
                aRet.append( ' ' );
            String aStyleName = aIter.next().toString();
            aRet.append( aStyleName );
        }	
        mRet = aRet.toString();
	}
    
	/**
	 * Returns a String Object representing this OdfStyleNames's value
	 * 
	 * @return return a string representation of the value of this OdfStyleNames object
	 */
    public String toString()
    {

        return mRet ;
    }

    /**
     * Returns a String List of OdfStyleNames which is represented by the specified String value
     * 
     * @param stringValue a String value which can construct an OdfStyleNames instance
     * @return return a String List of an OdfStyleNames instance constructed by stringValue
     */
    public static List<String> valueOf( String stringValue )
    {
        if( stringValue.length()==0 )
            return null;
        
        List<String> aRet = Arrays.asList( stringValue.split( " " ) );
        
        return aRet;
    }
    
    /*public static OdfStyleNames valueOf( String _aStringValue )
    {
        if( _aStringValue.length()==0 )
            return null;
        
        List<OdfStyleName> aRet = new ArrayList<OdfStyleName>();
        String[] names = _aStringValue.split( " " );
        for(int i = 0; i < names.length ; i++)
        {
        	aRet.add(new OdfStyleName(names[i]));
        }
        return new OdfStyleNames(aRet);
    }*/
}
