/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'styleNameRef'
 */
public class OdfStyleNameRef {
	
	String mStyleName;
	
	/**
	 * Construct OdfStyleNameRef by the parsing the given string 
	 * 
	 * @param styleName The String to be parsed into OdfStyleNameRef
	 */
	public OdfStyleNameRef(String styleName){
	
		if( (styleName.length() > 0)&& ( !styleName.matches("^[a-zA-Z_\u4e00-\u9fa5](\\w|.|-)*$") ))	
			throw new IllegalArgumentException( "Illegal StyleNameRef");
        mStyleName = styleName;
	}
    
	/**
	 * Returns a String Object representing this OdfStyleNameRef's value
	 * 
	 * @return return a string representation of the value of this OdfStyleNameRef object
	 */
    public String toString()
    {
        return mStyleName;
    }

    /**
     * Returns a String Object of OdfStyleNameRef which is represented by  the specified String value
     * 
     * @param stringValue a String value which can construct an OdfStyleNameRef
     * @return a String representation of an OdfStyleNameRef instance constructed by stringValue
     */
    public static String valueOf( String stringValue )
    {
        return new OdfStyleNameRef(stringValue).toString();
    }
}
