/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'positiveInteger'
 */
public class OdfPositiveInteger {
    
    int mN;
    
    /**
	 * Allocates an OdfPositiveInteger object representing the n argument
	 * 
	 * @param n the value of the OdfPositiveInteger
	 */
	public OdfPositiveInteger (int n){
        if( n < 1 )
            throw new IllegalArgumentException( "Illegal ODFPositiveInteger value");        
        mN = n;
	}

	/**
	 * Returns a String Object representing this OdfPositiveInteger's value
	 * 
	 * @return return a string representation of the value of this OdfPositiveInteger object
	 */
	public String toString()
    {
        return Integer.toString(mN);
    }
	
	/**
     * Returns an OdfPositiveInteger instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfPositiveInteger instance representing stringValue
     */
    public static OdfPositiveInteger valueOf( String stringValue )
    {
        if( stringValue.length()==0 )
            return null;
        
        String aTmp = stringValue.trim();
        int n = Integer.valueOf(aTmp);
        return new OdfPositiveInteger(n);
    }
    
    /**
     * Returns the value of this OdfPositiveInteger object as a int primitive
     *
     * @return  the primitive int value of this OdfPositiveInteger object.
     */
    public int intValue()
    {
    	return mN;
    }
}
