/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/


package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'percent'
 */
public class OdfPercent
{
    private double mN;
    
    /**
	 * Allocates an OdfPercent object representing the n argument
	 * 
	 * @param n the value of the OdfPercent
	 */
    public OdfPercent (double n ){
    	mN = n ;
    }
    
    /**
	 * Returns a String Object representing this OdfPercent's value
	 * 
	 * @return return a string representation of the value of this OdfPercent object
	 */
	public String toString( )
    {
        return Double.toString( mN ) + "%";
    }

	/**
     * Returns an OdfPercent instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfPercent instance representing stringValue
     */
    public static OdfPercent valueOf( String stringValue )
    {
        if( (stringValue == null) || (stringValue.length() == 0) )
            return new OdfPercent(0.0);

        int n = stringValue.indexOf( "%" );
    	if( n != -1 )
            return new OdfPercent(Double.valueOf( stringValue.substring(0,n) ).doubleValue() / 100);
        else
            throw new IllegalArgumentException( "Illegal percentage value");
    }
    
    /**
     * Returns the value of this OdfPercent object as a double primitive
     *
     * @return  the primitive double value of this OdfPercent object.
     */
    public double doubleValue()
    {
    	return mN;
    }
}
