/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.odftoolkit.odfdom.dom.type;

import org.odftoolkit.odfdom.dom.util.OdfUnitConverter;

/**
 * DOM implementation of OpenDocument data type 'measure'
 *
 * converts odf measure strings from to units in cm.
 */
public class OdfMeasure
{

    private int mMeasure;

    /**
	 * Allocates an OdfMeasure object representing the measure argument
	 * 
	 * @param measure the value of the OdfMeasure
	 */
    public OdfMeasure ( int measure )
    {
    	mMeasure = measure;
    }
    
    /**
	 * Returns a String Object representing this OdfMeasure's value
	 * 
	 * @return return a string representation of the value of this OdfMeasure object
	 */
    public String toString( )
    {
        return OdfUnitConverter.getMeasureString(mMeasure);
    }

    /**
     * Returns an OdfMeasure instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfMeasure instance representing stringValue
     */
    public static OdfMeasure valueOf( String stringValue )
    {
        return new OdfMeasure(OdfUnitConverter.getMeasureValue(stringValue));
    }
    
    /**
     * Returns the value of this OdfMeasure object as a int primitive
     *
     * @return  the primitive int value of this OdfMeasure object.
     */
    public int intValue()
    {
    	return mMeasure;
    }
    
}
