/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'ID'
 */
public class OdfId {
	
	private String mId;
	
	/**
	 * Construct OdfId by the parsing the given string 
	 * 
	 * @param id The String to be parsed into OdfId
	 */
	public OdfId (String id)
	{
		if( ! id.matches("^[_a-zA-Z](\\w|.|-)*$"))	
			throw new IllegalArgumentException( "Illegal OdfId");
		mId = id;
	}
 
	/**
	 * Returns a String Object representing this OdfId's value
	 * 
	 * @return return a string representation of the value of this OdfId object
	 */
    public String toString()
    {
        // TODO: check for NCName
        return  mId;
    }

    /**
     * Returns an OdfId instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfId instance representing stringValue
     */
    public static OdfId valueOf( String stringValue )
    {
        return new OdfId(stringValue);
    }
}
