/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;

/**
 * DOM implementation of OpenDocument data type 'duration'
 */
public class OdfDuration {
	
	private Duration mDuration;
	
	/**
	 * Construct OdfDuration by the parsing the given string 
	 * 
	 * @param duration The String to be parsed into OdfDuration
	 */
	public OdfDuration ( Duration duration)
	{
		mDuration = duration;
	}
    
	/**
	 * Returns a String Object representing this OdfDuration's value
	 * 
	 * @return return a string representation of the value of this OdfDuration object
	 */
    public String toString( )
    {
        return mDuration.toString();
    }

    /**
     * Returns an OdfDuration instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfDuration instance representing stringValue
     */
    public static OdfDuration valueOf( String stringValue )
    {
        if( stringValue.length()==0 )
            return null;

        try {
            DatatypeFactory aFactory = DatatypeFactory.newInstance();
            return new OdfDuration(aFactory.newDuration(stringValue));
        } catch (DatatypeConfigurationException ex) {
            throw new IllegalArgumentException( ex );
        }
    }
    
    /**
     * Returns the value of this OdfDuration object as an Duration 
     *
     * @return  the Duration value of this OdfDuration object.
     */
    public Duration getValue()
    {
    	return mDuration;
    }
}
