/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

/**
 * DOM implementation of OpenDocument data type 'date'
 */
public class OdfDate {
	
	private XMLGregorianCalendar mDate;
	
	/**
	 * Construct OdfDate by the parsing the given string 
	 * 
	 * @param date The String to be parsed into OdfDate
	 */
	public OdfDate ( XMLGregorianCalendar date)
	{
		mDate = date;
	}
    
	/**
	 * Returns a String Object representing this OdfDate's value
	 * 
	 * @return return a string representation of the value of this OdfDate object
	 */
    public String toString()
    {
        return mDate.toString();
    }

    /**
     * Returns an OdfDate instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfDate instance representing stringValue
     */
    public static OdfDate valueOf( String stringValue )
    {
        if( stringValue.length()==0 )
            return null;
        
        DatatypeFactory aFactory = new org.apache.xerces.jaxp.datatype.DatatypeFactoryImpl();
        return new OdfDate(aFactory.newXMLGregorianCalendar(stringValue));
    }
    
    /**
     * Returns the value of this OdfDate object as an XMLGregorianCalendar 
     *
     * @return  the XMLGregorianCalendar value of this OdfDate object.
     */
    public XMLGregorianCalendar getValue()
    {
    	return mDate;
    }
}
