/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'coordinate'
 */
public class OdfCoordinate {
 
    private String mCoordinate;
    /**
     * 
	 * Construct OdfCoordinate by the parsing the given string 
	 * 
     * @param coordinate The String to be parsed into OdfCoordinate
     */
    public  OdfCoordinate (String  coordinate){
        if( !coordinate.matches("^-?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)((cm)|(mm)|(in)|(pt)|(pc)|(px))$") )
            throw new IllegalArgumentException( "Illegal coordinate");
        mCoordinate = coordinate;
    }
    
	// TODO: Should a coordinate stay a string?
    /**
	 * Returns a String Object representing this OdfCoordinate's value
	 * 
	 * @return return a string representation of the value of this OdfCoordinate object
	 */
    public String toString( )
    {  
        return mCoordinate;
    }

    /**
     * Returns an OdfCoordinate instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfCoordinate instance representing stringValue
     */
    public static OdfCoordinate valueOf( String stringValue )
    {
        return new OdfCoordinate(stringValue);
    }
}
