/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * DOM implementation of OpenDocument data type 'cellRangeAddressList'
 */
public class OdfCellRangeAddressList {
 

	private  String mCellRangeAddressList;
	
	/**
	 * Construct OdfCellRangeAddressList by the parsing the given string 
	 * 
	 * @param cellRangeAddressList The String to be parsed into OdfCellRangeAddressList
	 */
	public  OdfCellRangeAddressList (List<OdfCellRangeAddress> cellRangeAddressList )
	{
		StringBuffer aRet = new StringBuffer();
        Iterator<OdfCellRangeAddress> aIter = cellRangeAddressList.iterator();
        while( aIter.hasNext() )
        {
            if( aRet.length() > 0 )
                aRet.append( ' ' );
            String aStyleName = aIter.next().toString();
            aRet.append( aStyleName );
        }	
        mCellRangeAddressList = aRet.toString();
	}
	
	// TODO: Should a cell address stay a string?
	/**
	 * Returns a String Object representing this OdfCellRangeAddressList's value
	 * 
	 * @return return a string representation of the value of this OdfCellRangeAddressList object
	 */
    public String toString()
    {
        return mCellRangeAddressList;
    }

    /**
     * Returns an OdfCellRangeAddressList instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfCellRangeAddressList instance representing stringValue
     */
    public static OdfCellRangeAddressList valueOf( String stringValue )
    {
    	if( stringValue.length()==0 )
            return null;
        
        List<OdfCellRangeAddress> aRet = new ArrayList<OdfCellRangeAddress>();
        String[] names = stringValue.split( " " );
        for(int i = 0; i < names.length ; i++)
        {
        	aRet.add(new OdfCellRangeAddress(names[i]));
        }
        return new OdfCellRangeAddressList(aRet);
    }
}
