/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'cellRangeAddress'
 */
public class OdfCellRangeAddress {
 

	private  String mCellRangeAddress;
	
	/**
	 * Construct OdfCellRangeAddress by the parsing the given string 
	 * 
	 * @param cellRangeAddress The String to be parsed into OdfCellRangeAddress
	 */
	public  OdfCellRangeAddress (String cellRangeAddress )
	{
		if( ! (cellRangeAddress.matches("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+(:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+)?$")
				|| cellRangeAddress.matches("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[0-9]+:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[0-9]+$") 
				|| cellRangeAddress.matches("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+:(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+$") 
				) )
            throw new IllegalArgumentException( "Illegal cell range address");
		mCellRangeAddress = cellRangeAddress;
	}
	
	// TODO: Should a cell address stay a string?
	/**
	 * Returns a String Object representing this OdfCellRangeAddress's value
	 * 
	 * @return return a string representation of the value of this OdfCellRangeAddress object
	 */
    public String toString()
    {
        return mCellRangeAddress;
    }

    /**
     * Returns an OdfCellRangeAddress instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfCellRangeAddress instance representing stringValue
     */
    public static OdfCellRangeAddress valueOf( String stringValue )
    {
        return new OdfCellRangeAddress(stringValue);
    }
}
