/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;
        
/**
 * DOM implementation of OpenDocument data type 'cellAddress'
 */
public class OdfCellAddress {
	
	private String mCellAddress;
	
	/**
	 * Construct OdfCellAddress by the parsing the given string 
	 * @param cellAddress The String to be parsed into OdfCellAddress
	 */
	public OdfCellAddress ( String cellAddress)
	{
	      if( !cellAddress.matches("^(\\$?([^\\. ']+|'([^']|'')+'))?\\.\\$?[A-Z]+\\$?[0-9]+$") )
	            throw new IllegalArgumentException( "Illegal cell address");
	      mCellAddress = cellAddress;
	}
 
    // TODO: Should a cell address stay a string?
	/**
	 * Returns a String Object representing this OdfCellAddress's value
	 * 
	 * @return return a string representation of the value of this OdfCellAddress object
	 */
    public String toString()
    {
 
        return mCellAddress;
    }

    /**
     * Returns an OdfCellAddress instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfCellAddress instance representing stringValue
     */
    public static OdfCellAddress valueOf( String stringValue )
    {
        return new OdfCellAddress(stringValue);
    }
}
