/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

/**
 * DOM implementation of OpenDocument data type 'boolean'
 */

public class OdfBoolean {
	
	private boolean mBool;
	
	/**
	 * Allocates an OdfBoolean object representing the bool argument
	 * 
	 * @param bool the value of the OdfBoolean
	 */
	public OdfBoolean (boolean bool ) {
		
		mBool = bool ;
	}
    
	/**
	 * Returns a String Object representing this OdfBoolean's value
	 * 
	 * @return return a string representation of the value of this OdfBoolean object
	 */
    public String toString()
    {
        return Boolean.toString(mBool);
    }

    /**
     * Returns an OdfBoolean instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfBoolean instance representing stringValue
     */
    public static OdfBoolean valueOf( String stringValue )
    {
        if( stringValue.length()==0 )
            return null;
        
        String aTmp = stringValue.trim();
        
        if( aTmp.equals("true") || aTmp.equals("1") )
            return new OdfBoolean(true);
        else if( aTmp.equals("false") || aTmp.equals("0") )
            return new OdfBoolean(false);
        else        
            throw new IllegalArgumentException( "Illegal ODFBoolean value");
    }
    
    /**
     * Returns the value of this OdfBoolean object as a boolean primitive
     *
     * @return  the primitive boolean value of this OdfBoolean object.
     */
    public boolean booleanValue()
    {
    	return mBool;
    }
}
