/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * Use is subject to license terms.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/
package org.odftoolkit.odfdom.dom.type;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.odftoolkit.odfdom.dom.util.URITransformer;

/**
 * DOM implementation of OpenDocument data type 'anyURI'
 */
public class OdfAnyURI {
	
	private URI mURI;
	
	/**
	 * Construct OdfAnyURI by the parsing the given string 
	 * 
	 * @param path The String to be parsed into an OdfAnyURI
	 * @throws URISyntaxException if path is invalidate
	 */
	public OdfAnyURI( String path) throws URISyntaxException{
		mURI = new URI(URITransformer.encodePath(path).toString());
	}
    
	/**
	 * Returns a String Object representing this OdfAnyURI's value
	 * 
	 * @return return a string representation of the value of this OdfAnyURI object
	 */
    public String toString()
    {
    	return URITransformer.decodePath(mURI.toString());
    }
    
    /**
     * Returns an OdfAnyURI instance representing the specified String value
     * 
     * @param stringValue a String value
     * @return return an OdfAnyURI instance representing stringValue
     */
    public static OdfAnyURI valueOf( String stringValue )
    {
    	try {
			return new OdfAnyURI(stringValue);
		} catch (URISyntaxException e) {
			Logger.getLogger(OdfAnyURI.class.getName()).log(Level.SEVERE, null, e);
		}
		return null;
    }
    
    /**
     * get java.net.URI from OdfAnyURI
     * 
     * @return java.net.URI returned from this OdfAnyURI
     */
    public URI toURI()
    {
    	return mURI;
    }
}
