/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfIndexScopeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:user-index-source}.
 *
 */
public abstract class OdfUserIndexSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "user-index-source" );

    /**
     * Create the instance of OdfUserIndexSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfUserIndexSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:user-index-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfUserIndexSourceElement}
     *
     *@param indexName  The mandatory attribute {@attributeName  text:index-name}" 
     *
     */
    public void init(String indexName)
    {
        setIndexName( indexName );
    }

    /**
     * Get value of attribute {@attributeName text:index-scope}.
     *
     *@return return the attribute which type is OdfIndexScopeType
     */
    public OdfIndexScopeType getIndexScope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "document";
        }

        return OdfIndexScopeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:index-scope}.
     *
     *@param  indexScope    the attribute's type is OdfIndexScopeType
     */ 
     public void setIndexScope( OdfIndexScopeType indexScope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ), indexScope.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRelativeTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@param  isRelativeTabStopPosition    the attribute's type is OdfBoolean
     */ 
     public void setRelativeTabStopPosition( OdfBoolean isRelativeTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ), isRelativeTabStopPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-index-marks}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseIndexMarks()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-marks" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-index-marks}.
     *
     *@param  isUseIndexMarks    the attribute's type is OdfBoolean
     */ 
     public void setUseIndexMarks( OdfBoolean isUseIndexMarks )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-marks" ), isUseIndexMarks.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-index-source-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseIndexSourceStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-source-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-index-source-styles}.
     *
     *@param  isUseIndexSourceStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseIndexSourceStyles( OdfBoolean isUseIndexSourceStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-source-styles" ), isUseIndexSourceStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-graphics}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseGraphics()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-graphics" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-graphics}.
     *
     *@param  isUseGraphics    the attribute's type is OdfBoolean
     */ 
     public void setUseGraphics( OdfBoolean isUseGraphics )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-graphics" ), isUseGraphics.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-tables}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseTables()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-tables" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-tables}.
     *
     *@param  isUseTables    the attribute's type is OdfBoolean
     */ 
     public void setUseTables( OdfBoolean isUseTables )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-tables" ), isUseTables.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-floating-frames}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseFloatingFrames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-floating-frames" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-floating-frames}.
     *
     *@param  isUseFloatingFrames    the attribute's type is OdfBoolean
     */ 
     public void setUseFloatingFrames( OdfBoolean isUseFloatingFrames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-floating-frames" ), isUseFloatingFrames.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-objects}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseObjects()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-objects" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-objects}.
     *
     *@param  isUseObjects    the attribute's type is OdfBoolean
     */ 
     public void setUseObjects( OdfBoolean isUseObjects )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-objects" ), isUseObjects.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:copy-outline-levels}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCopyOutlineLevels()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "copy-outline-levels" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:copy-outline-levels}.
     *
     *@param  isCopyOutlineLevels    the attribute's type is OdfBoolean
     */ 
     public void setCopyOutlineLevels( OdfBoolean isCopyOutlineLevels )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "copy-outline-levels" ), isCopyOutlineLevels.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:index-name}.
     *
     *@return return the attribute which type is String
     */
    public String getIndexName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:index-name}.
     *
     *@param  indexName    the attribute's type is String
     */ 
     public void setIndexName( String indexName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ), indexName );
    }

    /**
    * Create child element {@odfLink text:index-title-template}.
    *
    *@return   return  the element {@odfLink text:index-title-template}
    */
    public OdfIndexTitleTemplateElement createIndexTitleTemplateElement()
    {
        OdfIndexTitleTemplateElement  nIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleTemplateElement.class);
        this.appendChild( nIndexTitleTemplate);
        return  nIndexTitleTemplate;
    }                   
               
    /**
    * Create child element {@odfLink text:user-index-entry-template}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink text:user-index-entry-template}
    */
    public OdfUserIndexEntryTemplateElement createUserIndexEntryTemplateElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfUserIndexEntryTemplateElement  nUserIndexEntryTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexEntryTemplateElement.class);
        nUserIndexEntryTemplate.setOutlineLevel( outlineLevel);
        nUserIndexEntryTemplate.setStyleName( styleName);
        this.appendChild( nUserIndexEntryTemplate);
        return  nUserIndexEntryTemplate;      
    }
    
    /**
    * Create child element {@odfLink text:index-source-styles}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:index-source-styles}
    */
    public OdfIndexSourceStylesElement createIndexSourceStylesElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfIndexSourceStylesElement  nIndexSourceStyles = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexSourceStylesElement.class);
        nIndexSourceStyles.setOutlineLevel( outlineLevel);
        this.appendChild( nIndexSourceStyles);
        return  nIndexSourceStyles;      
    }
    
}
