/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:user-index-mark-start}.
 *
 */
public abstract class OdfUserIndexMarkStartElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "user-index-mark-start" );

    /**
     * Create the instance of OdfUserIndexMarkStartElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfUserIndexMarkStartElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:user-index-mark-start}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfUserIndexMarkStartElement}
     *
     *@param id  The mandatory attribute {@attributeName  text:id}" 
     *@param indexName  The mandatory attribute {@attributeName  text:index-name}" 
     *
     */
    public void init(String id, String indexName)
    {
        setId( id );
        setIndexName( indexName );
    }

    /**
     * Get value of attribute {@attributeName text:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName text:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName text:outline-level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:outline-level}.
     *
     *@param  outlineLevel    the attribute's type is OdfPositiveInteger
     */ 
     public void setOutlineLevel( OdfPositiveInteger outlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ), outlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:index-name}.
     *
     *@return return the attribute which type is String
     */
    public String getIndexName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:index-name}.
     *
     *@param  indexName    the attribute's type is String
     */ 
     public void setIndexName( String indexName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ), indexName );
    }

}
