/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:user-index-mark}.
 *
 */
public abstract class OdfUserIndexMarkElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "user-index-mark" );

    /**
     * Create the instance of OdfUserIndexMarkElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfUserIndexMarkElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:user-index-mark}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfUserIndexMarkElement}
     *
     *@param stringValue  The mandatory attribute {@attributeName  text:string-value}" 
     *@param indexName  The mandatory attribute {@attributeName  text:index-name}" 
     *
     */
    public void init(String stringValue, String indexName)
    {
        setStringValue( stringValue );
        setIndexName( indexName );
    }

    /**
     * Get value of attribute {@attributeName text:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName text:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "string-value" ), stringValue );
    }

    /**
     * Get value of attribute {@attributeName text:outline-level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:outline-level}.
     *
     *@param  outlineLevel    the attribute's type is OdfPositiveInteger
     */ 
     public void setOutlineLevel( OdfPositiveInteger outlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ), outlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:index-name}.
     *
     *@return return the attribute which type is String
     */
    public String getIndexName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:index-name}.
     *
     *@param  indexName    the attribute's type is String
     */ 
     public void setIndexName( String indexName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-name" ), indexName );
    }

}
