/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.Duration;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:user-field-decls}.
 *
 */
public abstract class OdfUserFieldDeclsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "user-field-decls" );

    /**
     * Create the instance of OdfUserFieldDeclsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfUserFieldDeclsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:user-field-decls}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param value Double   
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, Double   value, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setValue( value);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param dateValue    the attribute's type is XMLGregorianCalendar
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDate   dateValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setDateValue( dateValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param timeValue    the attribute's type is Duration
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDuration   timeValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setTimeValue( timeValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param booleanValue  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfBoolean   booleanValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setBooleanValue( booleanValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
}
