/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.text.OdfIndexScopeType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:table-of-content-source}.
 *
 */
public abstract class OdfTableOfContentSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "table-of-content-source" );

    /**
     * Create the instance of OdfTableOfContentSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableOfContentSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:table-of-content-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:outline-level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:outline-level}.
     *
     *@param  outlineLevel    the attribute's type is OdfPositiveInteger
     */ 
     public void setOutlineLevel( OdfPositiveInteger outlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "outline-level" ), outlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-outline-level}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-outline-level" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-outline-level}.
     *
     *@param  isUseOutlineLevel    the attribute's type is OdfBoolean
     */ 
     public void setUseOutlineLevel( OdfBoolean isUseOutlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-outline-level" ), isUseOutlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-index-marks}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseIndexMarks()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-marks" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-index-marks}.
     *
     *@param  isUseIndexMarks    the attribute's type is OdfBoolean
     */ 
     public void setUseIndexMarks( OdfBoolean isUseIndexMarks )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-marks" ), isUseIndexMarks.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:use-index-source-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseIndexSourceStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-source-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:use-index-source-styles}.
     *
     *@param  isUseIndexSourceStyles    the attribute's type is OdfBoolean
     */ 
     public void setUseIndexSourceStyles( OdfBoolean isUseIndexSourceStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "use-index-source-styles" ), isUseIndexSourceStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:index-scope}.
     *
     *@return return the attribute which type is OdfIndexScopeType
     */
    public OdfIndexScopeType getIndexScope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ) );
        return OdfIndexScopeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:index-scope}.
     *
     *@param  indexScope    the attribute's type is OdfIndexScopeType
     */ 
     public void setIndexScope( OdfIndexScopeType indexScope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "index-scope" ), indexScope.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRelativeTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:relative-tab-stop-position}.
     *
     *@param  isRelativeTabStopPosition    the attribute's type is OdfBoolean
     */ 
     public void setRelativeTabStopPosition( OdfBoolean isRelativeTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "relative-tab-stop-position" ), isRelativeTabStopPosition.toString() );
    }

    /**
    * Create child element {@odfLink text:index-title-template}.
    *
    *@return   return  the element {@odfLink text:index-title-template}
    */
    public OdfIndexTitleTemplateElement createIndexTitleTemplateElement()
    {
        OdfIndexTitleTemplateElement  nIndexTitleTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleTemplateElement.class);
        this.appendChild( nIndexTitleTemplate);
        return  nIndexTitleTemplate;
    }                   
               
    /**
    * Create child element {@odfLink text:table-of-content-entry-template}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param styleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink text:table-of-content-entry-template}
    */
    public OdfTableOfContentEntryTemplateElement createTableOfContentEntryTemplateElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   styleName)
    {
        OdfTableOfContentEntryTemplateElement  nTableOfContentEntryTemplate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableOfContentEntryTemplateElement.class);
        nTableOfContentEntryTemplate.setOutlineLevel( outlineLevel);
        nTableOfContentEntryTemplate.setStyleName( styleName);
        this.appendChild( nTableOfContentEntryTemplate);
        return  nTableOfContentEntryTemplate;      
    }
    
    /**
    * Create child element {@odfLink text:index-source-styles}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:index-source-styles}
    */
    public OdfIndexSourceStylesElement createIndexSourceStylesElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfIndexSourceStylesElement  nIndexSourceStyles = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexSourceStylesElement.class);
        nIndexSourceStyles.setOutlineLevel( outlineLevel);
        this.appendChild( nIndexSourceStyles);
        return  nIndexSourceStyles;      
    }
    
}
