/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import org.odftoolkit.odfdom.dom.type.OdfId;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:table-of-content}.
 *
 */
public abstract class OdfTableOfContentElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "table-of-content" );

    /**
     * Create the instance of OdfTableOfContentElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableOfContentElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Section, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:table-of-content}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTableOfContentElement}
     *
     *@param name  The mandatory attribute {@attributeName  text:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName text:protected}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getProtected()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protected" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:protected}.
     *
     *@param  isProtected    the attribute's type is OdfBoolean
     */ 
     public void setProtected( OdfBoolean isProtected )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protected" ), isProtected.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:protection-key}.
     *
     *@return return the attribute which type is String
     */
    public String getProtectionKey()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protection-key" ) );
    }

    /**
     * Set value of attribute {@attributeName text:protection-key}.
     *
     *@param  protectionKey    the attribute's type is String
     */ 
     public void setProtectionKey( String protectionKey )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protection-key" ), protectionKey );
    }

    /**
     * Get value of attribute {@attributeName text:protection-key-digest-algorithm}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getProtectionKeyDigestAlgorithm()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protection-key-digest-algorithm" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "http://www.w3.org/2000/09/xmldsig#sha1";
        }

        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:protection-key-digest-algorithm}.
     *
     *@param  protectionKeyDigestAlgorithm    the attribute's type is OdfAnyURI
     */ 
     public void setProtectionKeyDigestAlgorithm( OdfAnyURI protectionKeyDigestAlgorithm )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "protection-key-digest-algorithm" ), protectionKeyDigestAlgorithm.toString() );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
    * Create child element {@odfLink text:table-of-content-source}.
    *
    *@return   return  the element {@odfLink text:table-of-content-source}
    */
    public OdfTableOfContentSourceElement createTableOfContentSourceElement()
    {
        OdfTableOfContentSourceElement  nTableOfContentSource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableOfContentSourceElement.class);
        this.appendChild( nTableOfContentSource);
        return  nTableOfContentSource;
    }                   
               
    /**
    * Create child element {@odfLink text:index-body}.
    *
    *@return   return  the element {@odfLink text:index-body}
    */
    public OdfIndexBodyElement createIndexBodyElement()
    {
        OdfIndexBodyElement  nIndexBody = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexBodyElement.class);
        this.appendChild( nIndexBody);
        return  nIndexBody;
    }                   
               
}
