/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfValueFormulaDisplayType;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:table-formula}.
 *
 */
public abstract class OdfTableFormulaElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "table-formula" );

    /**
     * Create the instance of OdfTableFormulaElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableFormulaElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:table-formula}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:formula}.
     *
     *@return return the attribute which type is String
     */
    public String getFormula()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "formula" ) );
    }

    /**
     * Set value of attribute {@attributeName text:formula}.
     *
     *@param  formula    the attribute's type is String
     */ 
     public void setFormula( String formula )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "formula" ), formula );
    }

    /**
     * Get value of attribute {@attributeName text:display}.
     *
     *@return return the attribute which type is OdfValueFormulaDisplayType
     */
    public OdfValueFormulaDisplayType getDisplay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display" ) );
        return OdfValueFormulaDisplayType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:display}.
     *
     *@param  display    the attribute's type is OdfValueFormulaDisplayType
     */ 
     public void setDisplay( OdfValueFormulaDisplayType display )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display" ), display.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:data-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDataStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:data-style-name}.
     *
     *@param  dataStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDataStyleName( OdfStyleNameRef dataStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ), dataStyleName.toString() );
    }

}
