/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfKeyType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:sort-key}.
 *
 */
public abstract class OdfSortKeyElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "sort-key" );

    /**
     * Create the instance of OdfSortKeyElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSortKeyElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:sort-key}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSortKeyElement}
     *
     *@param key  The mandatory attribute {@attributeName  text:key}" 
     *
     */
    public void init(OdfKeyType key)
    {
        setKey( key );
    }

    /**
     * Get value of attribute {@attributeName text:key}.
     *
     *@return return the attribute which type is OdfKeyType
     */
    public OdfKeyType getKey()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key" ) );
        return OdfKeyType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:key}.
     *
     *@param  key    the attribute's type is OdfKeyType
     */ 
     public void setKey( OdfKeyType key )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "key" ), key.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:sort-ascending}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSortAscending()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-ascending" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:sort-ascending}.
     *
     *@param  isSortAscending    the attribute's type is OdfBoolean
     */ 
     public void setSortAscending( OdfBoolean isSortAscending )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "sort-ascending" ), isSortAscending.toString() );
    }

}
