/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:sequence}.
 *
 */
public abstract class OdfSequenceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "sequence" );

    /**
     * Create the instance of OdfSequenceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSequenceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:sequence}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSequenceElement}
     *
     *@param name  The mandatory attribute {@attributeName  text:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName text:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName text:formula}.
     *
     *@return return the attribute which type is String
     */
    public String getFormula()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "formula" ) );
    }

    /**
     * Set value of attribute {@attributeName text:formula}.
     *
     *@param  formula    the attribute's type is String
     */ 
     public void setFormula( String formula )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "formula" ), formula );
    }

    /**
     * Get value of attribute {@attributeName style:num-format}.
     *
     *@return return the attribute which type is String
     */
    public String getNumFormat()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ) );
    }

    /**
     * Set value of attribute {@attributeName style:num-format}.
     *
     *@param  numFormat    the attribute's type is String
     */ 
     public void setNumFormat( String numFormat )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-format" ), numFormat );
    }

    /**
     * Get value of attribute {@attributeName style:num-letter-sync}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getNumLetterSync()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:num-letter-sync}.
     *
     *@param  isNumLetterSync    the attribute's type is OdfBoolean
     */ 
     public void setNumLetterSync( OdfBoolean isNumLetterSync )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "num-letter-sync" ), isNumLetterSync.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:ref-name}.
     *
     *@return return the attribute which type is String
     */
    public String getRefName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ref-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:ref-name}.
     *
     *@param  refName    the attribute's type is String
     */ 
     public void setRefName( String refName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "ref-name" ), refName );
    }

}
