/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:sequence-decl}.
 *
 */
public abstract class OdfSequenceDeclElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "sequence-decl" );

    /**
     * Create the instance of OdfSequenceDeclElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSequenceDeclElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:sequence-decl}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfSequenceDeclElement}
     *
     *@param name  The mandatory attribute {@attributeName  text:name}" 
     *@param displayOutlineLevel  The mandatory attribute {@attributeName  text:display-outline-level}" 
     *
     */
    public void init(String name, OdfNonNegativeInteger displayOutlineLevel)
    {
        setName( name );
        setDisplayOutlineLevel( displayOutlineLevel );
    }

    /**
     * Get value of attribute {@attributeName text:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName text:display-outline-level}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getDisplayOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display-outline-level" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:display-outline-level}.
     *
     *@param  displayOutlineLevel    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setDisplayOutlineLevel( OdfNonNegativeInteger displayOutlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "display-outline-level" ), displayOutlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:separation-character}.
     *
     *@return return the attribute which type is String
     */
    public String getSeparationCharacter()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "separation-character" ) );
    }

    /**
     * Set value of attribute {@attributeName text:separation-character}.
     *
     *@param  separationCharacter    the attribute's type is String
     */ 
     public void setSeparationCharacter( String separationCharacter )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "separation-character" ), separationCharacter );
    }

}
