/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:section-source}.
 *
 */
public abstract class OdfSectionSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "section-source" );

    /**
     * Create the instance of OdfSectionSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSectionSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:section-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
    }

    /**
     * Get value of attribute {@attributeName text:section-name}.
     *
     *@return return the attribute which type is String
     */
    public String getSectionName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "section-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:section-name}.
     *
     *@param  sectionName    the attribute's type is String
     */ 
     public void setSectionName( String sectionName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "section-name" ), sectionName );
    }

    /**
     * Get value of attribute {@attributeName text:filter-name}.
     *
     *@return return the attribute which type is String
     */
    public String getFilterName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "filter-name" ) );
    }

    /**
     * Set value of attribute {@attributeName text:filter-name}.
     *
     *@param  filterName    the attribute's type is String
     */ 
     public void setFilterName( String filterName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "filter-name" ), filterName );
    }

}
