/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:ruby}.
 *
 */
public abstract class OdfRubyElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "ruby" );

    /**
     * Create the instance of OdfRubyElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfRubyElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.Ruby, OdfName.get( OdfNamespace.TEXT, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:ruby}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
    * Create child element {@odfLink text:ruby-base}.
    *
    *@return   return  the element {@odfLink text:ruby-base}
    */
    public OdfRubyBaseElement createRubyBaseElement()
    {
        OdfRubyBaseElement  nRubyBase = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRubyBaseElement.class);
        this.appendChild( nRubyBase);
        return  nRubyBase;
    }                   
               
    /**
    * Create child element {@odfLink text:ruby-text}.
    *
    *@return   return  the element {@odfLink text:ruby-text}
    */
    public OdfRubyTextElement createRubyTextElement()
    {
        OdfRubyTextElement  nRubyText = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRubyTextElement.class);
        this.appendChild( nRubyText);
        return  nRubyText;
    }                   
               
}
