/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.text;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfPlaceholderType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink text:placeholder}.
 *
 */
public abstract class OdfPlaceholderElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TEXT, "placeholder" );

    /**
     * Create the instance of OdfPlaceholderElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPlaceholderElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink text:placeholder}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfPlaceholderElement}
     *
     *@param placeholderType  The mandatory attribute {@attributeName  text:placeholder-type}" 
     *
     */
    public void init(OdfPlaceholderType placeholderType)
    {
        setPlaceholderType( placeholderType );
    }

    /**
     * Get value of attribute {@attributeName text:placeholder-type}.
     *
     *@return return the attribute which type is OdfPlaceholderType
     */
    public OdfPlaceholderType getPlaceholderType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "placeholder-type" ) );
        return OdfPlaceholderType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:placeholder-type}.
     *
     *@param  placeholderType    the attribute's type is OdfPlaceholderType
     */ 
     public void setPlaceholderType( OdfPlaceholderType placeholderType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "placeholder-type" ), placeholderType.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:description}.
     *
     *@return return the attribute which type is String
     */
    public String getDescription()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "description" ) );
    }

    /**
     * Set value of attribute {@attributeName text:description}.
     *
     *@param  description    the attribute's type is String
     */ 
     public void setDescription( String description )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "description" ), description );
    }

}
