/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    
package org.odftoolkit.odfdom.dom.element.text;
import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import java.util.List;
import org.odftoolkit.odfdom.dom.type.OdfStyleNames;
import org.odftoolkit.odfdom.dom.type.OdfId;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;


/**
 * DOM implementation of OpenDocument base element 
 */
public abstract class OdfParagraphElementBase extends OdfStylableElement
{
    /**
     * Create the instance of OdfParagraphElementBase 
     *
     *@param  aOwnerDoc      The type is OdfFileDom
     *@param  aElement_name   The type is OdfName
     *@param  aStyleFamily    The type is OdfStyleFamily
     *@param  aStyleAttrName  The type is OdfName  
     */
    public OdfParagraphElementBase( OdfFileDom aOwnerDoc ,OdfName aElementName ,OdfStyleFamily aStyleFamily ,OdfName aStyleAttrName )
    {
        super( aOwnerDoc, aElementName, aStyleFamily, aStyleAttrName );
    }
    /**
     * Initialization of the mandatory attributes of {@link  OdfParagraphElementBase}
     *
     
    *
     */
    public void init()
    {
    }
      
    /**
     * Get value of attribute {@attributeName text:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:style-name}.
     *
     *@param  styleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setStyleName( OdfStyleNameRef styleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "style-name" ), styleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:class-names}.
     *
     *@return return the attribute which type is List<String>
     */
    public List<String> getClassNames()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "class-names" ) );
        return OdfStyleNames.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:class-names}.
     *
     *@param  classNames    the attribute's type is OdfStyleNames
     */ 
     public void setClassNames( OdfStyleNames classNames )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "class-names" ), classNames.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:cond-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getCondStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "cond-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:cond-style-name}.
     *
     *@param  condStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setCondStyleName( OdfStyleNameRef condStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "cond-style-name" ), condStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName text:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName xml:id}.
     *
     *@return return the attribute which type is OdfId
     */
    public OdfId getXmlid()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ) );
        return OdfId.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xml:id}.
     *
     *@param  xmlid    the attribute's type is OdfId
     */ 
     public void setXmlid( OdfId xmlid )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XML, "id" ), xmlid.toString() );
    }

    /**
     * Get value of attribute {@attributeName xhtml:about}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getAbout()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xhtml:about}.
     *
     *@param  about    the attribute's type is OdfAnyURI
     */ 
     public void setAbout( OdfAnyURI about )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "about" ), about.toString() );
    }

    /**
     * Get value of attribute {@attributeName xhtml:property}.
     *
     *@return return the attribute which type is String
     */
    public String getProperty()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:property}.
     *
     *@param  property    the attribute's type is String
     */ 
     public void setProperty( String property )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "property" ), property );
    }

    /**
     * Get value of attribute {@attributeName xhtml:datatype}.
     *
     *@return return the attribute which type is String
     */
    public String getDatatype()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:datatype}.
     *
     *@param  datatype    the attribute's type is String
     */ 
     public void setDatatype( String datatype )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "datatype" ), datatype );
    }

    /**
     * Get value of attribute {@attributeName xhtml:content}.
     *
     *@return return the attribute which type is String
     */
    public String getContent()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ) );
    }

    /**
     * Set value of attribute {@attributeName xhtml:content}.
     *
     *@param  content    the attribute's type is String
     */ 
     public void setContent( String content )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.XHTML, "content" ), content );
    }

}
      